/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.plugin.maven;

import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static org.apache.commons.lang3.StringUtils.join;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class PluginProperties {

  public static final String ARTIFACT_EXPORT_CLASS_PACKAGES = "artifact.export.classPackages";
  public static final String ARTIFACT_EXPORT_RESOURCES = "artifact.export.resources";
  public static final String PLUGIN_DEPENDENCIES = "plugin.dependencies";
  public static final String PLUGIN_BUNDLE = "plugin.bundle";
  private static final String PROPERTIES_COMMENT = "Plugin Properties";

  private String exportedPackages;
  private String pluginDependencies;
  private String exportedResources;
  private String pluginBundle;

  public PluginProperties(List<String> exportedPackageNames, List<String> exportedResources, Set<String> pluginDependencies) {
    this.exportedPackages = join(exportedPackageNames, ",");
    this.exportedResources = join(exportedResources, ",");
    this.pluginDependencies = join(pluginDependencies, ",");
  }

  public PluginProperties(String exportedPackages, String exportedResources, String pluginDependencies, String pluginBundle) {
    this.exportedPackages = exportedPackages != null ? exportedPackages : "";
    this.exportedResources = exportedResources != null ? exportedResources : "";
    this.pluginDependencies = pluginDependencies != null ? pluginDependencies : "";
    this.pluginBundle = pluginBundle != null ? pluginBundle : "";
  }

  public void writeTo(OutputStream out) throws IOException {
    Properties properties = new Properties();
    doWriteProperties(properties);
    properties.store(out, PROPERTIES_COMMENT);
  }

  protected void doWriteProperties(Properties properties) {
    properties.setProperty(ARTIFACT_EXPORT_RESOURCES, exportedResources);
    properties.setProperty(ARTIFACT_EXPORT_CLASS_PACKAGES, exportedPackages);
    if (isNotBlank(pluginDependencies)) {
      properties.setProperty(PLUGIN_DEPENDENCIES, pluginDependencies);
    }
    if (isNotBlank(pluginBundle)) {
      properties.setProperty(PLUGIN_BUNDLE, pluginBundle);
    }
  }
}
