package com.mulesoft.adapter.helper;

import com.sap.aii.af.service.administration.api.monitoring.ChannelDirection;
import com.sap.aii.af.service.administration.api.monitoring.MonitoringManager;
import com.sap.aii.af.service.administration.api.monitoring.MonitoringManagerFactory;
import com.sap.aii.af.service.administration.api.monitoring.ProcessContext;
import com.sap.aii.af.service.administration.api.monitoring.ProcessContextFactory;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import com.sap.aii.af.service.cpa.Channel;
import com.sap.aii.af.service.cpa.Direction;
import com.sap.engine.interfaces.messaging.api.Message;
import com.sap.engine.interfaces.messaging.api.PublicAPIAccessFactory;
import com.sap.engine.interfaces.messaging.api.auditlog.AuditAccess;
import com.sap.engine.interfaces.messaging.api.auditlog.AuditLogStatus;
import com.sap.engine.interfaces.messaging.api.exception.MessagingException;

public class PILogger implements IPILogger {

    private final Channel channel;
    private Message piMessage;
    private final ChannelDirection channelDirection;

    public PILogger(Channel channel) {
        this.channel = channel;
        channelDirection = determineDirection(channel);
    }

    public PILogger(Channel channel, Message piMessage) {
        this.channel = channel;
        this.piMessage = piMessage;
        channelDirection = determineDirection(channel);
    }

    private ChannelDirection determineDirection(Channel channel) {
        return Direction.OUTBOUND.equals(channel.getDirection()) ? ChannelDirection.RECEIVER : ChannelDirection.SENDER;
    }
    
    public void setPiMessage(Message piMessage) {
        this.piMessage = piMessage;
    }

    @Override
    public void reportProcessingStatus(ProcessState status, String message, Object... messageParameters) {
        MonitoringManager monitoringManager = MonitoringManagerFactory.getInstance().getMonitoringManager();

        ProcessContext processContext = ProcessContextFactory.getInstance().createProcessContext(
                ProcessContextFactory.getParamSet().message(piMessage).channel(channel));

        monitoringManager.reportProcessStatus(channel.getAdapterNamespace(), channel.getAdapterType(), channelDirection, status, message, messageParameters,
                processContext);
    }

    @Override
    public void reportAuditStatus(AuditLogStatus status, String message, Object... messageParameters) {
        if (piMessage == null)
            throw new NullPointerException("piMessage has to be set to report to Audit log");
            
        AuditAccess auditAccess = getAuditAccess();
        auditAccess.addAuditLogEntry(piMessage.getMessageKey(), status, message, messageParameters);
    }

    private AuditAccess getAuditAccess() {
        AuditAccess auditAccess;
        try {
            auditAccess = PublicAPIAccessFactory.getPublicAPIAccess().getAuditAccess();
        } catch (MessagingException e) {
            throw new RuntimeException("Audit access is not available", e);
        }
        return auditAccess;
    }
}
