package com.mulesoft.adapter.helper;

import java.io.IOException;

import com.sap.engine.interfaces.messaging.api.Message;
import com.sap.engine.interfaces.messaging.api.exception.InvalidParamException;
import com.sap.engine.interfaces.messaging.api.exception.PayloadFormatException;

public abstract class Payload {
    
    /**
     * Populate a message with provided XML payload.
     * @param message
     * @param payload
     * @throws IOException
     * @throws InvalidParamException
     * @throws PayloadFormatException 
     */
    public static void populateMessage(final Message message, final byte[] payload) throws InvalidParamException, PayloadFormatException {
        final com.sap.engine.interfaces.messaging.api.Payload messagePayload = message.createPayload();
        messagePayload.setContent(payload);
        messagePayload.setName("MainDocument");
        messagePayload.setDescription("Salesforce Document");
        messagePayload.setContentType("text/xml");
        message.setMainPayload(messagePayload);
    }

}
