/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.adapter.module;

import javax.resource.ResourceException;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;

import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.ra.XIMessageRecordImpl;

/**
 * Abstracts PI module.
 */
public interface PIModule {

    /**
     * @param spec
     * @param input
     * @return result of this module execution
     * @throws ResourceException 
     */
    Record execute(final InteractionSpec spec, final XIMessageRecordImpl input, IPILogger logger) throws ResourceException;

    /**
     * Dispose this module.
     */
    void dispose();
    
    /**
     * perform retry of delivery
     * @param cause exeption that occured
     * @return whether to retry delivering the message
     */
    boolean retryOn(Throwable cause);

}