/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.adapter.module.salesforce;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.resource.ResourceException;

import org.mule.api.MuleException;
import org.mule.tools.module.invocation.DynamicModule;

import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.helper.XML;
import com.mulesoft.adapter.module.AbstractOperationHandler;
import com.mulesoft.adapter.module.PIMessageParameters;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import com.sap.engine.interfaces.messaging.api.auditlog.AuditLogStatus;
import com.sforce.soap.partner.DeleteResult;

/**
 * Provide support for `delete` operation.
 * 
 * Expected input format:
 * 
 * <delete>
 *   <ids>1</ids>
 *   <ids>2</ids>
 * </delete>
 * 
 * A single `delete` group is expected.
 * 
 * @see http://www.salesforce.com/us/developer/docs/api/Content/sforce_api_calls_delete.htm
 * @see http://www.salesforce.com/us/developer/resources/soap/sforce60/sforce_API_messages_delete.html
 */
public class DeleteOperationHandler extends AbstractOperationHandler {

    private static final String PROCESSOR_NAME = "delete";
    private static final String IDS_PARAMETER_NAME = "ids";

    public DeleteOperationHandler(final DynamicModule module) {
        super(DeleteOperationHandler.PROCESSOR_NAME, module);
    }

    @Override
    public final byte[] handle(PIMessageParameters messageParameters) throws MuleException, ResourceException {
        final List<List<String>> idGroups = XML.textNodes(messageParameters.getRequestContent());
        if (idGroups.isEmpty()) {
            throw new IllegalArgumentException("No delete group identified.");
        }
        if (idGroups.size() >1) {
            throw new IllegalArgumentException("More than a single delete group has been sent.");
        }
        final List<String> ids = idGroups.get(0);
        final Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(DeleteOperationHandler.IDS_PARAMETER_NAME, ids);
        
        IPILogger logger = messageParameters.getLogger();
        logger.reportAuditStatus(AuditLogStatus.SUCCESS, "deleting ids: {0}", ids);

        logger.reportProcessingStatus(ProcessState.OK, "invoking operation");
        final List<DeleteResult> results = invoke(parameters);
        logger.reportProcessingStatus(ProcessState.OK, "invocation finished");
        Results.throwIfDeleteNotSuccessful(results);
        return null;
    }

}