/*
 * $Id: URIBuilder.java 23505 2011-12-20 08:20:49Z mike.schilling $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package com.mulesoft.adapter.module.salesforce;

import java.net.MalformedURLException;
import java.net.URL;

import com.sforce.ws.transport.JdkHttpTransport;

/**
 * A variant of Salesforce's HTTP transport optimized for running inside SAP
 */
public class SAPHttpTransport extends JdkHttpTransport
{
    /**
     * Work around SAP issues with default HTTP[S] transport
     * @param url
     * @return
     * @throws MalformedURLException
     */
    @Override
    public URL createURL(String url) throws MalformedURLException
    {
        String lower = url.toLowerCase();
        if (lower.startsWith("https"))
        {
            return new URL(null, url, new sun.net.www.protocol.https.Handler());
        }
        else if (lower.startsWith("http"))
        {
            return new URL(null, url, new sun.net.www.protocol.http.Handler());
        }
        else
        {
            return super.createURL(url);
        }
    }
}
