package com.mulesoft.adapter.module.salesforce;

import java.util.HashMap;
import java.util.Map;

import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.tools.module.invocation.DynamicModule;

import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;

/**
 * Helper used to cache describe-operation results
 */
public class SObjectTypeFinder {
    
    private final String type;
    private final DynamicModule module;
    private DescribeSObjectResult sObjectDescription;

    public SObjectTypeFinder(String type, DynamicModule module) {
        this.type = type;
        this.module = module;
    }
    
    /**
     * cache type description
     */
    public void init() throws InitialisationException, MuleException {
        final Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(SObjects.TYPE_ATTRIBUTE_NAME, type);
        sObjectDescription = module.invoke("describe-sobject", parameters);
    }
    
    /**
     * 
     * @param name the field name
     * @return the Field or null if not found in type
     * @throws MuleException
     */
    public Field findField(final String name) {
        if (sObjectDescription == null)
            throw new NullPointerException("Not initialized");
        
        for (final Field field : sObjectDescription.getFields()) {
            if (name.equals(field.getName())) {
                return field;
            }
        }
        
        return null;
    }

}
