/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.helper;

import com.sap.aii.af.service.cpa.CPAException;
import com.sap.aii.af.service.cpa.Channel;
import com.sap.engine.interfaces.messaging.api.DeliverySemantics;
import javax.resource.ResourceException;

public final class Channels {
    private static final String USERNAME_PARAMETER_NAME = "username";
    private static final String PASSWORD_PARAMETER_NAME = "password";
    private static final String SECURITY_TOKEN_PARAMETER_NAME = "securityToken";
    private static final String QOS_PARAMETER_NAME = "qos";
    private static final String EOIO_SEQUENCEID_PARAMETER_NAME = "qos.eoio.sequenceId";
    private static final String QUERY_RESPONSE_XML_ROOT_ELEMENT_NAME_PARAMETER_NAME = "queryResponseXMLRootElement";
    private static final String SUBSCRIPTION_RESPONSE_XML_ROOT_ELEMENT_NAME_PARAMETER_NAME = "subscriptionResponseXMLRootElement";
    private static final String RESPONSE_XML_ROOT_ELEMENT_NAMESPACE_PARAMETER_NAME = "responseXMLRootElementNS";

    private Channels() {
    }

    public static boolean isDefined(String element) {
        return !"".equals(element);
    }

    public static String retrieveConfigurationElement(String name, Channel channel) throws ResourceException {
        try {
            return channel.getValueAsString(name);
        }
        catch (CPAException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public static String retrieveUsername(Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(USERNAME_PARAMETER_NAME, channel);
    }

    public static String retrievePassword(Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(PASSWORD_PARAMETER_NAME, channel);
    }

    public static String retrieveSecurityToken(Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(SECURITY_TOKEN_PARAMETER_NAME, channel);
    }

    public static DeliverySemantics retrieveQualityOfService(Channel channel) throws ResourceException {
        String qosValue = Channels.retrieveConfigurationElement(QOS_PARAMETER_NAME, channel);
        if ("EO".equals(qosValue)) {
            return DeliverySemantics.ExactlyOnce;
        }
        if ("EOIO".equals(qosValue)) {
            return DeliverySemantics.ExactlyOnceInOrder;
        }
        throw new ResourceException("Unknown QoS: " + qosValue);
    }

    public static String retrieveQueueName(Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(EOIO_SEQUENCEID_PARAMETER_NAME, channel);
    }

    public static String retrieveQueryResponseRootElementName(Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(QUERY_RESPONSE_XML_ROOT_ELEMENT_NAME_PARAMETER_NAME, channel);
    }

    public static String retrieveSubscriptionResponseRootElementName(Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(SUBSCRIPTION_RESPONSE_XML_ROOT_ELEMENT_NAME_PARAMETER_NAME, channel);
    }

    public static String retrieveResponseRootElementNamespace(Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(RESPONSE_XML_ROOT_ELEMENT_NAMESPACE_PARAMETER_NAME, channel);
    }

    public static int retrieveConfigurationElementAsInt(String name, Channel channel) throws ResourceException {
        try {
            return channel.getValueAsInt(name);
        }
        catch (CPAException e) {
            throw new ResourceException((Throwable)e);
        }
    }
}

