/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module.salesforce;

import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.UpsertResult;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalesForceUpsertErrorMessage {
    private final List<UpsertResult> results;
    private final StringBuilder errorMessage = new StringBuilder();

    public SalesForceUpsertErrorMessage(List<UpsertResult> results) {
        this.results = results;
    }

    public String errorMessage() {
        if (this.results == null) {
            return "";
        }
        this.appendNewLine();
        for (UpsertResult result : this.results) {
            this.appendErrorsFrom(result);
        }
        return this.errorMessage.toString();
    }

    protected final void appendNewLine() {
        if (this.errorMessage.length() > 0) {
            this.errorMessage.append(System.getProperty("line.separator"));
        }
    }

    private void appendErrorsFrom(UpsertResult saveResult) {
        if (saveResult.isSuccess()) {
            return;
        }
        for (Error error : saveResult.getErrors()) {
            this.errorMessage.append(error.getStatusCode());
            this.errorMessage.append(": ");
            this.errorMessage.append(error.getMessage());
        }
    }

    public final boolean isSuccess() {
        if (this.results == null) {
            return true;
        }
        for (UpsertResult result : this.results) {
            if (result.isSuccess()) continue;
            return false;
        }
        return true;
    }
}

