/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module.salesforce;

import com.mulesoft.adapter.helper.Channels;
import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.module.AbstractPIModule;
import com.mulesoft.adapter.module.salesforce.CreateOperationHandler;
import com.mulesoft.adapter.module.salesforce.DeleteOperationHandler;
import com.mulesoft.adapter.module.salesforce.QueryOperationHandler;
import com.mulesoft.adapter.module.salesforce.TransportConfigurator;
import com.mulesoft.adapter.module.salesforce.UpsertOperationHandler;
import com.mulesoft.adapter.ra.XIMessageFactoryImpl;
import com.sap.aii.af.lib.mp.processor.ModuleProcessorException;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import com.sap.aii.af.service.cpa.Channel;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.resource.ResourceException;
import org.mule.api.Capabilities;
import org.mule.api.ConnectionManager;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.modules.salesforce.config.SalesforceModuleConnectionManager;
import org.mule.modules.salesforce.config.SalesforceModuleLifecycleAdapter;
import org.mule.tools.module.loader.Loader;
import org.mule.tools.module.model.Module;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalesforcePIModule
extends AbstractPIModule {
    private static final String PROXY_HOST_PARAMETER_NAME = "proxyHost";
    private static final String PROXY_PORT_PARAMETER_NAME = "proxyPort";
    private static final String PROXY_USERNAME_PARAMETER_NAME = "proxyUsername";
    private static final String PROXY_PASSWORD_PARAMETER_NAME = "proxyPassword";
    private static final String TOPIC_PARAMETER_NAME = "topic";
    private static final String SUBSCRIBE_TOPIC_NAME = "subscribe-topic";

    public SalesforcePIModule(Channel channel) throws ResourceException {
        super(channel);
        this.registerSupportedOperationHandlers();
    }

    private void registerSupportedOperationHandlers() {
        this.register(new QueryOperationHandler(this.getModule()));
        this.register(new CreateOperationHandler(this.getModule()));
        this.register(new UpsertOperationHandler(this.getModule()));
        this.register(new DeleteOperationHandler(this.getModule()));
    }

    @Override
    protected final Module createModule(Channel channel) throws ResourceException {
        String username = Channels.retrieveUsername(channel);
        String password = Channels.retrievePassword(channel);
        String securityToken = Channels.retrieveSecurityToken(channel);
        Module module = new Loader().load((Capabilities)new SalesforceModuleLifecycleAdapter(), (ConnectionManager)new SalesforceModuleConnectionManager());
        module.setUsername(username);
        module.setPassword(password);
        module.setSecurityToken(securityToken);
        return module;
    }

    @Override
    public boolean retryOn(Throwable cause) {
        String SIGNATURE = "retryOn(final Throwable cause)";
        LOCATION.entering("retryOn(final Throwable cause)", new Object[]{cause});
        boolean retry = false;
        if (cause instanceof MessagingException) {
            Throwable causeOfCause = cause.getCause();
            if (causeOfCause instanceof UnexpectedErrorFault) {
                UnexpectedErrorFault exception = (UnexpectedErrorFault)causeOfCause;
                switch (exception.getExceptionCode()) {
                    case REQUEST_LIMIT_EXCEEDED: {
                        retry = true;
                    }
                }
            } else if (causeOfCause instanceof NoSuchElementException) {
                retry = causeOfCause.toString().contains("TotalRequests Limit exceeded");
            }
        }
        LOCATION.exiting("retryOn(final Throwable cause)", (Object)retry);
        return retry;
    }

    @Override
    protected final Map<String, Object> createParameters(Channel channel) throws ResourceException {
        String proxyHost = Channels.retrieveConfigurationElement(PROXY_HOST_PARAMETER_NAME, channel);
        int proxyPort = Channels.retrieveConfigurationElementAsInt(PROXY_PORT_PARAMETER_NAME, channel);
        String proxyUsername = Channels.retrieveConfigurationElement(PROXY_USERNAME_PARAMETER_NAME, channel);
        String proxyPassword = Channels.retrieveConfigurationElement(PROXY_PASSWORD_PARAMETER_NAME, channel);
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        if (Channels.isDefined(proxyHost)) {
            parameterValues.put(PROXY_HOST_PARAMETER_NAME, proxyHost);
            ProxySelector defaultProxySelector = ProxySelector.getDefault();
            ProxySelector.setDefault(new SalesforceProxySelector(defaultProxySelector, proxyHost, proxyPort != 0 ? proxyPort : 8080));
        }
        if (proxyPort != 0) {
            parameterValues.put(PROXY_PORT_PARAMETER_NAME, proxyPort);
        }
        if (Channels.isDefined(proxyUsername)) {
            parameterValues.put(PROXY_USERNAME_PARAMETER_NAME, proxyUsername);
        }
        if (Channels.isDefined(proxyPassword)) {
            parameterValues.put(PROXY_PASSWORD_PARAMETER_NAME, proxyPassword);
        }
        return parameterValues;
    }

    public final void subscribe(XIMessageFactoryImpl messageFactory, IPILogger logger) throws MuleException, ModuleProcessorException, ResourceException {
        if (messageFactory == null) {
            throw new IllegalArgumentException("null messageFactory");
        }
        String topicName = Channels.retrieveConfigurationElement(TOPIC_PARAMETER_NAME, this.getChannel());
        if (topicName == null) {
            throw new IllegalArgumentException("Cannot access mandatory parameter <topic>");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(TOPIC_PARAMETER_NAME, topicName);
        logger.reportProcessingStatus(ProcessState.OK, "subscribing to topic {0}", StringUtils.abbreviate((String)topicName, (int)120));
        new TransportConfigurator().configureNetweaverHttpTransport();
        this.subscribe(SUBSCRIBE_TOPIC_NAME, parameters, messageFactory);
        logger.reportProcessingStatus(ProcessState.OK, "subscribed, wating for data", new Object[0]);
    }

    public final void unsubscribe(IPILogger logger) throws MuleException {
        logger.reportProcessingStatus(ProcessState.OK, "unsubscribing", new Object[0]);
        this.unsubscribe(SUBSCRIBE_TOPIC_NAME);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SalesforceProxySelector
    extends ProxySelector {
        private final ProxySelector defaultProxySelector;
        private final String host;
        private final int port;

        public SalesforceProxySelector(ProxySelector defaultProxySelector, String host, int port) {
            this.host = host;
            this.port = port;
            this.defaultProxySelector = defaultProxySelector;
        }

        @Override
        public List<Proxy> select(URI uri) {
            try {
                if (uri.equals(new URI(this.host))) {
                    return Collections.singletonList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.host, this.port)));
                }
            }
            catch (URISyntaxException e) {
                LOCATION.warningT("Failed to parse url <" + this.host + ">");
                LOCATION.throwing((Throwable)e);
            }
            return this.defaultProxySelector.select(uri);
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException e) {
            LOCATION.warningT("Failed to connect to <" + uri + ">");
            LOCATION.throwing((Throwable)e);
        }
    }
}

