/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module.salesforce;

import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.helper.XML;
import com.mulesoft.adapter.module.AbstractOperationHandler;
import com.mulesoft.adapter.module.PIMessageParameters;
import com.mulesoft.adapter.module.salesforce.Bulks;
import com.mulesoft.adapter.module.salesforce.Results;
import com.mulesoft.adapter.module.salesforce.SObjects;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import com.sap.engine.interfaces.messaging.api.auditlog.AuditLogStatus;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import org.mule.api.MuleException;
import org.mule.tools.module.invocation.DynamicModule;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpsertOperationHandler
extends AbstractOperationHandler {
    private static final String PROCESSOR_NAME = "upsert";
    private static final String BULK_PROCESSOR_NAME = "upsert-bulk";
    private static final String EXTERNAL_ID_FIELD_NAME_PARAMETER_NAME = "externalIdFieldName";
    private static final String EXTERNAL_ID_FIELD_NAME_TAG_NAME = "externalIDFieldName";
    private static final String TYPE_PARAMETER_NAME = "type";
    private static final String OBJECTS_PARAMETER_NAME = "objects";
    private static final int MAX_RECORDS_NUMBER = 200;

    public UpsertOperationHandler(DynamicModule module) {
        super(PROCESSOR_NAME, module);
    }

    protected final void upsert(String externalIdFieldName, String type, List<Map<String, Object>> objects, IPILogger logger) throws MuleException, ResourceException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(EXTERNAL_ID_FIELD_NAME_PARAMETER_NAME, externalIdFieldName);
        parameters.put(TYPE_PARAMETER_NAME, type);
        parameters.put(OBJECTS_PARAMETER_NAME, objects);
        logger.reportProcessingStatus(ProcessState.OK, "invoking operation", new Object[0]);
        List results = (List)this.invoke(parameters);
        logger.reportProcessingStatus(ProcessState.OK, "invocation finished", new Object[0]);
        Results.throwIfUpsertNotSuccessful(results);
    }

    protected final void upsertBulk(String externalIdFieldName, String type, List<Map<String, String>> objects, IPILogger logger) throws MuleException, ResourceException, InterruptedException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(EXTERNAL_ID_FIELD_NAME_PARAMETER_NAME, externalIdFieldName);
        parameters.put(TYPE_PARAMETER_NAME, type);
        parameters.put(OBJECTS_PARAMETER_NAME, objects);
        logger.reportProcessingStatus(ProcessState.OK, "invoking bulk operation", new Object[0]);
        BatchInfo batchInfo = (BatchInfo)this.invoke(BULK_PROCESSOR_NAME, parameters);
        logger.reportProcessingStatus(ProcessState.OK, "awaiting bulk operation completion", new Object[0]);
        BatchResult batchResult = Bulks.awaitCompletion(this.getModule(), batchInfo);
        logger.reportProcessingStatus(ProcessState.OK, "invocation finished", new Object[0]);
        Bulks.throwIfNotSuccessful(batchResult);
    }

    @Override
    public final byte[] handle(PIMessageParameters messageParameters) throws MuleException, ResourceException {
        Document payload = messageParameters.getRequestContent();
        Map<String, List<Map<String, String>>> typeObjectMap = SObjects.parse(payload);
        if (typeObjectMap.isEmpty()) {
            throw new IllegalArgumentException("No SObjects identified.");
        }
        if (typeObjectMap.size() > 1) {
            throw new IllegalArgumentException("More than a single type has been sent.");
        }
        String externalIdFieldName = XML.firstNamedTextNode(payload, EXTERNAL_ID_FIELD_NAME_TAG_NAME);
        if (externalIdFieldName == null) {
            throw new IllegalArgumentException("null externalIdFieldName");
        }
        Map.Entry<String, List<Map<String, String>>> entry = typeObjectMap.entrySet().iterator().next();
        String type = entry.getKey();
        List<Map<String, String>> objects = entry.getValue();
        int size = objects.size();
        IPILogger logger = messageParameters.getLogger();
        logger.reportAuditStatus(AuditLogStatus.SUCCESS, "Message of type {0} contains {1} sObjects", type, size);
        if (size <= 200) {
            List<Map<String, Object>> typedTypeObjectsMap = SObjects.asTypedObject(this.getModule(), type, objects);
            this.upsert(externalIdFieldName, type, typedTypeObjectsMap, logger);
        } else {
            try {
                this.upsertBulk(externalIdFieldName, type, objects, logger);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return null;
    }
}

