/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.ra;

import com.mulesoft.adapter.helper.PILogger;
import com.mulesoft.adapter.helper.TopicListnenerLocking;
import com.mulesoft.adapter.module.salesforce.SalesforcePIModule;
import com.mulesoft.adapter.ra.CCIConnectionFactory;
import com.mulesoft.adapter.ra.CCIConnectionRequestInfo;
import com.mulesoft.adapter.ra.ChannelOperationTuple;
import com.mulesoft.adapter.ra.SPIManagedConnection;
import com.mulesoft.adapter.ra.XIAdapterCategories;
import com.mulesoft.adapter.ra.XIConfiguration;
import com.mulesoft.adapter.ra.XIMessageFactoryImpl;
import com.mulesoft.adapter.ra.XISecurityUtilities;
import com.mulesoft.adapter.ra.XITrace;
import com.sap.aii.af.service.administration.api.cpa.CPAFactory;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import com.sap.aii.af.service.cpa.CPAObjectType;
import com.sap.aii.af.service.cpa.Channel;
import com.sap.aii.af.service.cpa.Direction;
import com.sap.aii.af.service.resource.SAPAdapterResources;
import com.sap.engine.interfaces.connector.ManagedConnectionFactoryActivation;
import com.sap.engine.interfaces.messaging.api.PublicAPIAccessFactory;
import com.sap.engine.interfaces.messaging.api.auditlog.AuditAccess;
import com.sap.guid.GUID;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPIManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable,
Runnable,
ManagedConnectionFactoryActivation {
    static final long serialVersionUID = -2387046407149571208L;
    private static final XITrace TRACE = new XITrace(SPIManagedConnectionFactory.class.getName());
    private AuditAccess audit = null;
    private GUID mcfLocalGuid = null;
    private static int waitTime = 5000;
    public static final String JNDI_NAME = "deployedAdapters/com.mulesoft.adapter.ra/shareable/com.mulesoft.adapter.ra";
    transient PrintWriter logWriter;
    private static Object synchronizer = new Object();
    private SAPAdapterResources msRes = null;
    private int threadStatus = 0;
    private static final int TH_INIT = 0;
    private static final int TH_STARTED = 1;
    private static final int TH_STOPPED = 2;
    private InitialContext ctx = null;
    private XIConfiguration xIConfiguration = null;
    private Map<String, SPIManagedConnection> managedConnections = Collections.synchronizedMap(new HashMap());
    private transient XIMessageFactoryImpl mf = null;
    private static final String AM_CPA = "CPA";
    private String addressMode = null;
    private String adapterType = null;
    private String adapterNamespace = null;
    private int propWaitNum = 10;
    private int propWaitTime = 1000;
    private final Map<String, SalesforcePIModule> modulesPerChannel = new ConcurrentHashMap<String, SalesforcePIModule>();
    private final BlockingQueue<ChannelOperationTuple> channelUpdateQueue = new LinkedBlockingQueue<ChannelOperationTuple>();
    static final String ASMA_NAME = "JCAChannelID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIManagedConnectionFactory() throws ResourceException {
        String SIGNATURE = "SpiManagedConnectionFactory()";
        TRACE.entering("SpiManagedConnectionFactory()");
        try {
            this.ctx = new InitialContext();
            Object res = this.ctx.lookup("SAPAdapterResources");
            this.msRes = (SAPAdapterResources)res;
        }
        catch (Exception e) {
            TRACE.catching("SpiManagedConnectionFactory()", e);
            TRACE.errorT("SpiManagedConnectionFactory()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0011", "Access to XI AF MS resource failed. Adapter cannot be started.");
        }
        try {
            Object e = synchronizer;
            synchronized (e) {
                this.mcfLocalGuid = new GUID();
                TRACE.infoT("SpiManagedConnectionFactory()", XIAdapterCategories.CONNECT_AF, "This SPIManagedConnectionFactory has the GUID: " + this.mcfLocalGuid.toString());
            }
        }
        catch (Exception e) {
            TRACE.catching("SpiManagedConnectionFactory()", e);
            TRACE.debugT("SpiManagedConnectionFactory()", XIAdapterCategories.CONNECT_AF, "Creation of MCF GUID failed. Thus no periodic status report possible! Reason: " + e.getMessage());
        }
        TRACE.exiting("SpiManagedConnectionFactory()");
    }

    private void addTopicSubscription(Channel channel) {
        PILogger logger = new PILogger(channel, null);
        try {
            TopicListnenerLocking locking = new TopicListnenerLocking(channel);
            if (locking.aquireLock()) {
                SalesforcePIModule pIModule = new SalesforcePIModule(channel);
                this.modulesPerChannel.put(channel.getObjectId(), pIModule);
                pIModule.subscribe(this.mf, logger);
            } else {
                logger.reportProcessingStatus(ProcessState.OK, "Topic already locked, please see other cluster nodes of this channel", new Object[0]);
            }
        }
        catch (Exception e) {
            String SIGNATURE = "addTopicSubscription";
            TRACE.catching("addTopicSubscription", e);
            logger.reportProcessingStatus(ProcessState.FATAL, e.getMessage(), new Object[0]);
        }
    }

    private void removeTopicSubscription(Channel channel) {
        PILogger logger = new PILogger(channel, null);
        SalesforcePIModule piModule = this.modulesPerChannel.remove(channel.getObjectId());
        if (piModule != null) {
            TopicListnenerLocking locking = new TopicListnenerLocking(channel);
            try {
                locking.unlock();
                piModule.unsubscribe(logger);
            }
            catch (Exception e) {
                String SIGNATURE = "removeTopicSubscription";
                TRACE.catching("removeTopicSubscription", e);
                logger.reportProcessingStatus(ProcessState.FATAL, e.getMessage(), new Object[0]);
            }
        }
    }

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        String SIGNATURE = "createConnectionFactory(ConnectionManager cxManager)";
        TRACE.entering("createConnectionFactory(ConnectionManager cxManager)", new Object[]{cm});
        CCIConnectionFactory factory = new CCIConnectionFactory(this, cm);
        TRACE.exiting("createConnectionFactory(ConnectionManager cxManager)");
        return factory;
    }

    public Object createConnectionFactory() throws ResourceException {
        String SIGNATURE = "createConnectionFactory()";
        TRACE.entering("createConnectionFactory()");
        CCIConnectionFactory factory = new CCIConnectionFactory(this, null);
        TRACE.exiting("createConnectionFactory()");
        return factory;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        String SIGNATURE = "createManagedConnection(Subject subject, ConnectionRequestInfo info)";
        TRACE.entering("createManagedConnection(Subject subject, ConnectionRequestInfo info)", new Object[]{subject, info});
        String channelID = null;
        Channel channel = null;
        SPIManagedConnection mc = null;
        if (!(info instanceof CCIConnectionRequestInfo)) {
            TRACE.errorT("createManagedConnection(Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0013", "Received an unknown ConnectionRequestInfo. Cannot determine channelId!");
            ResourceException re = new ResourceException("Received an unknown ConnectionRequestInfo. Cannot determine channelId!");
            TRACE.throwing("createManagedConnection(Subject subject, ConnectionRequestInfo info)", re);
            throw re;
        }
        try {
            channelID = ((CCIConnectionRequestInfo)info).getChannelId();
            channel = (Channel)CPAFactory.getInstance().getLookupManager().getCPAObject(CPAObjectType.CHANNEL, channelID);
        }
        catch (Exception e) {
            TRACE.catching("createManagedConnection(Subject subject, ConnectionRequestInfo info)", e);
            TRACE.errorT("createManagedConnection(Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0014", "Cannot access the channel parameters of channel: " + channelID + ". Check whether the channel is stopped in the administrator console.");
            ResourceException re = new ResourceException("Cannot access the channel parameters of channel: " + channelID + ". Check whether the channel is stopped in the administrator console.");
            throw re;
        }
        PasswordCredential credential = XISecurityUtilities.getPasswordCredential(this, subject, info);
        mc = new SPIManagedConnection(this, credential, false, channelID, channel);
        if (mc != null) {
            this.managedConnections.put(channelID, mc);
            TRACE.debugT("createManagedConnection(Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT_AF, "For channelID {0} this managed connection is stored: {1}", new Object[]{channelID, mc});
        }
        TRACE.exiting("createManagedConnection(Subject subject, ConnectionRequestInfo info)");
        return mc;
    }

    void destroyManagedConnection(String channelID) throws ResourceException {
        String SIGNATURE = "destroyManagedConnection(String channelID)";
        TRACE.entering("destroyManagedConnection(String channelID)", new Object[]{channelID});
        SPIManagedConnection mc = null;
        try {
            mc = this.managedConnections.get(channelID);
            if (mc != null) {
                mc.sendEvent(1, null, mc);
                this.managedConnections.remove(channelID);
                mc.destroy(true);
                TRACE.debugT("destroyManagedConnection(String channelID)", XIAdapterCategories.CONNECT_AF, "ManagedConnection for channel ID {0} found and destroyed.", new Object[]{channelID});
            } else {
                TRACE.warningT("destroyManagedConnection(String channelID)", XIAdapterCategories.CONNECT_AF, "ManagedConnection for channel ID {0} not found.", new Object[]{channelID});
            }
        }
        catch (Exception e) {
            TRACE.catching("destroyManagedConnection(String channelID)", e);
            TRACE.errorT("destroyManagedConnection(String channelID)", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0015", "Received exception during ManagedConnection destroy: " + e.getMessage());
        }
        TRACE.exiting("destroyManagedConnection(String channelID)");
    }

    void removeManagedConnection(String channelID) {
        String SIGNATURE = "removeManagedConnection(String channelID)";
        TRACE.entering("removeManagedConnection(String channelID)", new Object[]{channelID});
        this.managedConnections.remove(channelID);
        TRACE.exiting("removeManagedConnection(String channelID)");
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        String SIGNATURE = "matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)";
        TRACE.entering("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", new Object[]{connectionSet, subject, info});
        SPIManagedConnection mcFound = null;
        CCIConnectionRequestInfo cciInfo = null;
        PasswordCredential pc = XISecurityUtilities.getPasswordCredential(this, subject, info);
        if (!(info instanceof CCIConnectionRequestInfo)) {
            TRACE.errorT("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT_AF, "Unknown ConnectionRequestInfo parameter received. Cannot match connection");
            return null;
        }
        cciInfo = (CCIConnectionRequestInfo)info;
        Iterator it = connectionSet.iterator();
        while (it.hasNext() && mcFound == null) {
            Object obj = it.next();
            if (obj instanceof SPIManagedConnection) {
                SPIManagedConnection mc = (SPIManagedConnection)obj;
                if (!mc.isDestroyed()) {
                    ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
                    if (XISecurityUtilities.isPasswordCredentialEqual(mc.getPasswordCredential(), pc) && mcf.equals(this) && mc.getChannelID().equalsIgnoreCase(cciInfo.getChannelId())) {
                        mcFound = mc;
                        TRACE.debugT("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT, "Found existing ManagedConnection in container set for channel {0}.", new Object[]{mc.getChannelID()});
                        continue;
                    }
                    TRACE.debugT("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT, "ManagedConnection in container set does not fit. Ignore.");
                    continue;
                }
                TRACE.debugT("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT, "Destroyed sample ManagedConnection in container set. Ignore.");
                continue;
            }
            TRACE.debugT("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT, "This is not a sample ManagedConnection in container set. Ignore.");
        }
        TRACE.exiting("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)");
        return mcFound;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        String SIGNATURE = "setLogWriter(PrintWriter out)";
        TRACE.entering("setLogWriter(PrintWriter out)", new Object[]{out});
        out.print("XI AF Sample Adapter has received a J2EE container log writer.");
        out.print("XI AF Sample Adapter will not use the J2EE container log writer. See the trace file for details.");
        this.logWriter = out;
        TRACE.exiting("setLogWriter(PrintWriter out)");
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    AuditAccess getAuditAccess() {
        return this.audit;
    }

    XIMessageFactoryImpl getXIMessageFactoryImpl() {
        return this.mf;
    }

    public boolean equals(Object obj) {
        SPIManagedConnectionFactory other;
        String SIGNATURE = "equals(Object obj)";
        TRACE.entering("equals(Object obj)", new Object[]{obj});
        boolean equal = false;
        if (obj instanceof SPIManagedConnectionFactory && this.adapterNamespace.equals((other = (SPIManagedConnectionFactory)obj).getAdapterNamespace()) && this.adapterType.equals(other.getAdapterType()) && this.addressMode.equals(other.getAddressMode())) {
            equal = true;
        }
        TRACE.exiting("equals(Object obj)");
        return equal;
    }

    public int hashCode() {
        String SIGNATURE = "hashCode()";
        TRACE.entering("hashCode()");
        int hash = 0;
        String propset = this.adapterNamespace + this.adapterType + this.addressMode;
        hash = propset.hashCode();
        TRACE.exiting("hashCode()");
        return hash;
    }

    public String getAddressMode() {
        String SIGNATURE = "getAddressMode()";
        TRACE.entering("getAddressMode()");
        TRACE.debugT("getAddressMode()", XIAdapterCategories.CONNECT, "Address determination mode =" + this.addressMode);
        TRACE.exiting("getAddressMode()");
        return this.addressMode;
    }

    public void setAddressMode(String addressMode) {
        this.addressMode = addressMode;
    }

    public void startMCF() throws ResourceException {
        String SIGNATURE = "startMCF()";
        TRACE.entering("startMCF()");
        if (this.threadStatus != 1) {
            try {
                this.threadStatus = 1;
                this.msRes.startRunnable((Runnable)this);
            }
            catch (Exception e) {
                TRACE.catching("startMCF()", e);
                this.threadStatus = 2;
                TRACE.errorT("startMCF()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0016", "Cannot start inbound message thread");
                ResourceException re = new ResourceException(e.getMessage());
                TRACE.throwing("startMCF()", re);
                throw re;
            }
        }
        TRACE.exiting("startMCF()");
    }

    public void stopMCF() throws ResourceException {
        String SIGNATURE = "stopMCF()";
        TRACE.entering("stopMCF()");
        this.unregisterSubscriptions();
        this.threadStatus = 2;
        try {
            this.xIConfiguration.stop();
        }
        catch (Exception e) {
            TRACE.catching("stopMCF()", e);
            TRACE.errorT("stopMCF()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0017", "Cannot stop inbound message thread. Reason: " + e.getMessage());
            ResourceException re = new ResourceException(e.getMessage());
            TRACE.throwing("stopMCF()", re);
            throw re;
        }
        TRACE.exiting("stopMCF()");
    }

    private void unregisterSubscriptions() throws ResourceException {
        LinkedList<Channel> inboundChannels = this.xIConfiguration.getCopy(Direction.INBOUND);
        ArrayList<ChannelOperationTuple> channelOperationTuples = new ArrayList<ChannelOperationTuple>(inboundChannels.size());
        for (Channel inboundChannel : inboundChannels) {
            ChannelOperationTuple channelOperationTuple = new ChannelOperationTuple(inboundChannel, ChannelOperationTuple.Operation.Remove);
            channelOperationTuples.add(channelOperationTuple);
        }
        this.updateChannels(channelOperationTuples);
        do {
            try {
                Thread.sleep(waitTime + 1000);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        } while (!this.modulesPerChannel.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String SIGNATURE = "run()";
        TRACE.entering("run()");
        String oldThreadName = Thread.currentThread().getName();
        String newThreadName = "XI AF Mule MCF " + this.mcfLocalGuid;
        try {
            Thread.currentThread().setName(newThreadName);
            TRACE.debugT("run()", XIAdapterCategories.CONNECT_AF, "Switched thread name to: {0}", new Object[]{newThreadName});
            boolean notSet = true;
            int numTry = 0;
            while (notSet && numTry < this.propWaitNum) {
                if (this.addressMode != null && this.adapterType != null && this.adapterNamespace != null) {
                    notSet = false;
                }
                TRACE.debugT("run()", XIAdapterCategories.CONNECT_AF, "MCF waits for setter completion. Try: {0} of {1}.", new Object[]{Integer.toString(++numTry), Integer.toString(this.propWaitNum)});
                try {
                    Thread.sleep(this.propWaitTime);
                }
                catch (Exception e) {
                    TRACE.catching("run()", e);
                }
            }
            if (this.addressMode == null) {
                this.addressMode = AM_CPA;
            }
            if (this.adapterType == null) {
                this.adapterType = "SFDC_GATEWAY";
            }
            if (this.adapterNamespace == null) {
                this.adapterNamespace = "urn:mulesoft.com:pi:sfdcgateway:meta";
            }
            if (this.xIConfiguration == null) {
                try {
                    this.xIConfiguration = new XIConfiguration(this.adapterType, this.adapterNamespace);
                    this.xIConfiguration.init(this);
                }
                catch (Exception e) {
                    TRACE.catching("run()", e);
                    TRACE.errorT("run()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0018", "Cannot instatiate the XI CPA handler. The inbound processing is stopped. Exception:" + e.toString());
                    this.threadStatus = 2;
                }
            }
            while (this.threadStatus == 1) {
                try {
                    while (!this.channelUpdateQueue.isEmpty()) {
                        ChannelOperationTuple channelOperationTuple = (ChannelOperationTuple)this.channelUpdateQueue.poll();
                        if (channelOperationTuple.getOperation() == ChannelOperationTuple.Operation.Remove) {
                            this.removeTopicSubscription(channelOperationTuple.getChannel());
                            continue;
                        }
                        this.addTopicSubscription(channelOperationTuple.getChannel());
                    }
                }
                catch (Exception e) {
                    TRACE.catching("run()", e);
                    TRACE.errorT("run()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0019", "Cannot access inbound channel configuration. Received exception: " + e.getMessage());
                }
                try {
                    SPIManagedConnectionFactory e = this;
                    synchronized (e) {
                        this.wait(waitTime);
                    }
                }
                catch (InterruptedException e1) {
                    TRACE.catching("run()", e1);
                    TRACE.errorT("run()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0020", "Inbound thread stopped. Received exception during wait period: " + e1.getMessage());
                    this.threadStatus = 2;
                }
            }
            Thread.currentThread().setName(oldThreadName);
        }
        catch (Throwable throwable) {
            Thread.currentThread().setName(oldThreadName);
            TRACE.debugT("run()", XIAdapterCategories.CONNECT_AF, "Switched thread name back to: {0}", new Object[]{oldThreadName});
            throw throwable;
        }
        TRACE.debugT("run()", XIAdapterCategories.CONNECT_AF, "Switched thread name back to: {0}", new Object[]{oldThreadName});
    }

    public void addChannel(Channel channel) {
        this.channelUpdateQueue.add(new ChannelOperationTuple(channel, ChannelOperationTuple.Operation.Add));
    }

    public void removeChannel(Channel channel) {
        this.channelUpdateQueue.add(new ChannelOperationTuple(channel, ChannelOperationTuple.Operation.Remove));
    }

    public void updateChannels(List<ChannelOperationTuple> channelOperations) {
        this.channelUpdateQueue.addAll(channelOperations);
    }

    public String getAdapterNamespace() {
        String SIGNATURE = "getAdapterNamespace()";
        TRACE.entering("getAdapterNamespace()");
        TRACE.exiting("getAdapterNamespace()");
        return this.adapterNamespace;
    }

    public String getAdapterType() {
        return this.adapterType;
    }

    public void setAdapterNamespace(String adapterNamespace) {
        String SIGNATURE = "setAdapterNamespace(String adapterNamespace)";
        TRACE.entering("setAdapterNamespace(String adapterNamespace)", new Object[]{adapterNamespace});
        this.adapterNamespace = adapterNamespace;
        TRACE.exiting("setAdapterNamespace(String adapterNamespace)");
    }

    public void setAdapterType(String adapterType) {
        String SIGNATURE = "setAdapterType(String adapterType)";
        TRACE.entering("setAdapterType(String adapterType)", new Object[]{adapterType});
        this.adapterType = adapterType;
        TRACE.exiting("setAdapterType(String adapterType)");
    }

    public GUID getMcfLocalGuid() {
        return this.mcfLocalGuid;
    }

    public void start() {
        String SIGNATURE = "start()";
        TRACE.entering("start()");
        String controlledMcfGuid = this.getMcfLocalGuid().toHexString();
        TRACE.infoT("start()", XIAdapterCategories.CONNECT_AF, "MCF with GUID {0} is started now. ({1})", new Object[]{controlledMcfGuid.toString(), SPIManagedConnectionFactory.class.getClassLoader()});
        try {
            this.audit = PublicAPIAccessFactory.getPublicAPIAccess().getAuditAccess();
        }
        catch (Exception e) {
            TRACE.catching("start()", e);
            TRACE.errorT("start()", XIAdapterCategories.CONNECT, "SOA.apt_sample.0035", "Unable to access the XI AF audit log. Reason: {0}. Adapter cannot not start the inbound processing!", e);
            TRACE.exiting("start()");
            return;
        }
        try {
            this.mf = new XIMessageFactoryImpl(this.adapterType, this.adapterNamespace);
        }
        catch (Exception e) {
            TRACE.catching("start()", e);
            TRACE.errorT("start()", XIAdapterCategories.CONNECT, "SOA.apt_sample.0037", "Unable to create XI message factory. Adapter cannot not start the inbound processing!");
            TRACE.exiting("start()");
            return;
        }
        try {
            this.startMCF();
            TRACE.infoT("start()", XIAdapterCategories.CONNECT_AF, "MCF with GUID {0} was started successfully.", new Object[]{controlledMcfGuid.toString()});
        }
        catch (Exception e) {
            TRACE.catching("start()", e);
            TRACE.errorT("start()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0038", "Start of MCF failed. Reason: {0}", e.getMessage());
        }
    }

    public void stop() {
        String SIGNATURE = "stop()";
        TRACE.entering("stop()");
        String controlledMcfGuid = this.getMcfLocalGuid().toHexString();
        TRACE.infoT("stop()", XIAdapterCategories.CONNECT_AF, "The running MCF with GUID {0} will be stopped now", new Object[]{controlledMcfGuid.toString()});
        try {
            this.stopMCF();
        }
        catch (Exception e) {
            TRACE.catching("stop()", e);
        }
        TRACE.infoT("stop()", XIAdapterCategories.CONNECT_AF, "MCF with GUID {0} was stopped successfully.", new Object[]{controlledMcfGuid.toString()});
        TRACE.exiting("stop()");
    }

    public boolean isRunning() {
        return this.threadStatus == 1;
    }
}

