/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.ra;

import com.mulesoft.adapter.ra.SPIManagedConnectionFactory;
import com.mulesoft.adapter.ra.XIAdapterCategories;
import com.mulesoft.adapter.ra.XILocalizationUtilities;
import com.mulesoft.adapter.ra.XITrace;
import com.sap.aii.af.service.administration.api.AdapterCallback;
import com.sap.aii.af.service.administration.api.AdapterCapability;
import com.sap.aii.af.service.administration.api.AdapterRegistry;
import com.sap.aii.af.service.administration.api.AdapterRegistryFactory;
import com.sap.aii.af.service.administration.api.cpa.CPAFactory;
import com.sap.aii.af.service.administration.api.cpa.CPALookupManager;
import com.sap.aii.af.service.administration.api.cpa.ChannelLifecycleCallback;
import com.sap.aii.af.service.administration.api.i18n.LocalizationCallback;
import com.sap.aii.af.service.administration.api.i18n.LocalizationNotPossibleException;
import com.sap.aii.af.service.administration.api.monitoring.ChannelState;
import com.sap.aii.af.service.administration.api.monitoring.ChannelStatus;
import com.sap.aii.af.service.administration.api.monitoring.ChannelStatusCallback;
import com.sap.aii.af.service.administration.api.monitoring.ChannelStatusFactory;
import com.sap.aii.af.service.administration.api.monitoring.ChannelUnknownException;
import com.sap.aii.af.service.cpa.Channel;
import com.sap.aii.af.service.cpa.Direction;
import java.util.LinkedList;
import java.util.Locale;
import javax.resource.ResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XIConfiguration
implements ChannelLifecycleCallback,
ChannelStatusCallback,
LocalizationCallback {
    private static final XITrace TRACE = new XITrace(XIConfiguration.class.getName());
    private static String ADAPTER_TYPE = "SFDC_GATEWAY";
    private static String ADAPTER_NAMESPACE = "urn:mulesoft.com:pi:sfdcgateway:meta";
    private String adapterType;
    private String adapterNamespace;
    private LinkedList<Channel> outboundChannels = null;
    private LinkedList<Channel> inboundChannels = null;
    private CPALookupManager lookupManager = null;
    private AdapterRegistry adapterRegistry = null;
    private LocalizationCallback localizer = null;
    private SPIManagedConnectionFactory mcf = null;

    public XIConfiguration() {
        this(ADAPTER_TYPE, ADAPTER_NAMESPACE);
    }

    public XIConfiguration(String adapterType, String adapterNamespace) {
        String SIGNATURE = "XIConfiguration(String adapterType, String adapterNamespace)";
        TRACE.entering("XIConfiguration(String adapterType, String adapterNamespace)", new Object[]{adapterType, adapterNamespace});
        try {
            CPAFactory cf = CPAFactory.getInstance();
            this.lookupManager = cf.getLookupManager();
        }
        catch (Exception e) {
            TRACE.catching("XIConfiguration(String adapterType, String adapterNamespace)", e);
            TRACE.errorT("XIConfiguration(String adapterType, String adapterNamespace)", XIAdapterCategories.CONFIG, "SOA.apt_sample.0040", "CPALookupManager cannot be instantiated due to {0}", e.getMessage());
            TRACE.errorT("XIConfiguration(String adapterType, String adapterNamespace)", XIAdapterCategories.CONFIG, "SOA.apt_sample.0041", "No channel configuration can be read, no message exchange possible!");
        }
        this.adapterType = adapterType;
        this.adapterNamespace = adapterNamespace;
        TRACE.exiting("XIConfiguration(String adapterType, String adapterNamespace)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelAdded(Channel channel) {
        String SIGNATURE = "channelAdded(Channel channel)";
        TRACE.entering("channelAdded(Channel channel)", new Object[]{channel});
        XIConfiguration xIConfiguration = this;
        synchronized (xIConfiguration) {
            if (channel.getDirection() == Direction.INBOUND) {
                this.inboundChannels.add(channel);
                this.mcf.addChannel(channel);
            } else if (channel.getDirection() == Direction.OUTBOUND) {
                this.outboundChannels.add(channel);
            }
        }
        TRACE.infoT("channelAdded(Channel channel)", XIAdapterCategories.CONNECT_AF, "Channel with ID {0} for party {1} and service {2} added (direction is {3}).", new Object[]{channel.getObjectId(), channel.getParty(), channel.getService(), channel.getDirection().toString()});
        TRACE.exiting("channelAdded(Channel channel)");
    }

    public void channelUpdated(Channel channel) {
        String SIGNATURE = "channelUpdated(Channel channel)";
        TRACE.entering("channelUpdated(Channel channel)");
        this.channelRemoved(channel);
        this.channelAdded(channel);
        TRACE.exiting("channelUpdated(Channel channel)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRemoved(Channel channel) {
        String SIGNATURE = "channelRemoved(Channel channel)";
        TRACE.entering("channelRemoved(Channel channel)", new Object[]{channel});
        LinkedList<Channel> channels = null;
        TRACE.infoT("channelRemoved(Channel channel)", XIAdapterCategories.CONNECT_AF, "Channel with ID {0} for party {1} and service {2} will be removed now. (direction is {3}).", new Object[]{channel.getObjectId(), channel.getParty(), channel.getService(), channel.getDirection().toString()});
        String channelID = channel.getObjectId();
        channels = channel.getDirection() == Direction.INBOUND ? this.inboundChannels : this.outboundChannels;
        XIConfiguration xIConfiguration = this;
        synchronized (xIConfiguration) {
            for (int i = 0; i < channels.size(); ++i) {
                Channel storedChannel = channels.get(i);
                if (!storedChannel.getObjectId().equalsIgnoreCase(channelID)) continue;
                channels.remove(i);
                if (channel.getDirection() == Direction.OUTBOUND) {
                    try {
                        this.mcf.destroyManagedConnection(channelID);
                    }
                    catch (Exception e) {
                        TRACE.catching("channelRemoved(Channel channel)", e);
                        TRACE.warningT("channelRemoved(Channel channel)", XIAdapterCategories.CONNECT_AF, "The ManagedConnection for channel {0} cannot be destroyed. Configuration update might not work.", new Object[]{channelID});
                    }
                    break;
                }
                this.mcf.removeChannel(channel);
                break;
            }
        }
        TRACE.exiting("channelRemoved(Channel channel)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(SPIManagedConnectionFactory mcf) throws ResourceException {
        String SIGNATURE = "init(mcf)";
        TRACE.entering("init(mcf)");
        this.mcf = mcf;
        try {
            this.localizer = XILocalizationUtilities.getLocalizationCallback();
            AdapterRegistryFactory arf = AdapterRegistryFactory.getInstance();
            this.adapterRegistry = arf.getAdapterRegistry();
            this.adapterRegistry.registerAdapter(this.adapterNamespace, this.adapterType, new AdapterCapability[]{AdapterCapability.PUSH_PROCESS_STATUS}, new AdapterCallback[]{this});
        }
        catch (Exception e) {
            TRACE.catching("init(mcf)", e);
            ResourceException re = new ResourceException("XI AAM registration failed due to: " + e.getMessage());
            TRACE.throwing("init(mcf)", re);
            throw re;
        }
        XIConfiguration xIConfiguration = this;
        synchronized (xIConfiguration) {
            this.inboundChannels = new LinkedList();
            this.outboundChannels = new LinkedList();
            try {
                LinkedList allChannels = this.lookupManager.getChannelsByAdapterType(this.adapterType, this.adapterNamespace);
                TRACE.debugT("init(mcf)", XIAdapterCategories.CONNECT_AF, "The XI AAM service returned {0} channels for adapter type {1} with namespace {2}", new Object[]{new Integer(allChannels.size()), this.adapterType, this.adapterNamespace});
                for (Channel channel : allChannels) {
                    this.channelAdded(channel);
                }
            }
            catch (Exception e) {
                TRACE.catching("init(mcf)", e);
                ResourceException re = new ResourceException("XI CPA lookup failed due to: " + e.getMessage());
                TRACE.throwing("init(mcf)", re);
                throw re;
            }
        }
        TRACE.exiting("init(mcf)");
    }

    public void stop() throws ResourceException {
        String SIGNATURE = "stop()";
        TRACE.entering("stop()");
        try {
            this.adapterRegistry.unregisterAdapter(this.adapterNamespace, this.adapterType);
        }
        catch (Exception e) {
            TRACE.catching("stop()", e);
            ResourceException re = new ResourceException("XI AAM unregistration failed due to: " + e.getMessage());
            TRACE.throwing("stop()", re);
            throw re;
        }
        TRACE.exiting("stop()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<Channel> getCopy(Direction direction) throws ResourceException {
        String SIGNATURE = "getCopy(Direction direction)";
        LinkedList out = null;
        if (this.inboundChannels == null || this.outboundChannels == null) {
            this.init(this.mcf);
        }
        XIConfiguration xIConfiguration = this;
        synchronized (xIConfiguration) {
            if (direction == Direction.INBOUND) {
                out = (LinkedList)this.inboundChannels.clone();
            } else if (direction == Direction.OUTBOUND) {
                out = (LinkedList)this.outboundChannels.clone();
            } else {
                ResourceException re = new ResourceException("Direction invalid");
                TRACE.throwing("getCopy(Direction direction)", re);
                throw re;
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelStatus getChannelStatus(Channel channel, Locale locale) throws ChannelUnknownException {
        String SIGNATURE = "getChannelStatus(Channel channel, Locale locale)";
        TRACE.entering("getChannelStatus(Channel channel, Locale locale)", new Object[]{channel, locale});
        boolean channelFound = false;
        Channel storedChannel = null;
        String channelID = "<unknown>";
        Exception cause = null;
        ChannelStatus cs = null;
        try {
            channelID = channel.getObjectId();
            LinkedList<Channel> channels = null;
            channels = channel.getDirection() == Direction.INBOUND ? this.inboundChannels : this.outboundChannels;
            XIConfiguration xIConfiguration = this;
            synchronized (xIConfiguration) {
                for (int i = 0; i < channels.size(); ++i) {
                    storedChannel = channels.get(i);
                    if (!storedChannel.getObjectId().equalsIgnoreCase(channelID)) continue;
                    channelFound = true;
                    break;
                }
            }
        }
        catch (Exception e) {
            TRACE.catching("getChannelStatus(Channel channel, Locale locale)", e);
            cause = e;
            TRACE.errorT("getChannelStatus(Channel channel, Locale locale)", XIAdapterCategories.CONFIG, "SOA.apt_sample.0046", "Channel lookup failed due to {0}.", e.getMessage());
        }
        if (!channelFound) {
            ChannelUnknownException cue = new ChannelUnknownException("Channel with ID " + channelID + " is not known.", (Throwable)cause);
            TRACE.errorT("getChannelStatus(Channel channel, Locale locale)", XIAdapterCategories.CONFIG, "SOA.apt_sample.0047", "Channel {0} is not known.", channelID);
            TRACE.throwing("getChannelStatus(Channel channel, Locale locale)", (Throwable)cue);
            throw cue;
        }
        ChannelStatusFactory csf = ChannelStatusFactory.getInstance();
        if (csf == null) {
            ChannelUnknownException cue = new ChannelUnknownException("Internal error: Unable to get instance of ChannelStatusFactory.", (Throwable)cause);
            TRACE.errorT("getChannelStatus(Channel channel, Locale locale)", XIAdapterCategories.CONFIG, "SOA.apt_sample.0048", "Unable to get instance of ChannelStatusFactory.");
            TRACE.throwing("getChannelStatus(Channel channel, Locale locale)", (Throwable)cue);
            throw cue;
        }
        try {
            if (storedChannel.getDirection() == Direction.INBOUND && !this.mcf.isRunning()) {
                cs = csf.createChannelStatus(channel, ChannelState.ERROR, "The JCA adapter inbound thread is not working correctly. No inbound messages possible!");
                TRACE.exiting("getChannelStatus(Channel channel, Locale locale)", new Object[]{cs});
                return cs;
            }
            cs = csf.createChannelStatus(channel, ChannelState.OK, this.localizer.localizeString("CHANNEL_OK", locale));
        }
        catch (Exception e) {
            TRACE.catching("getChannelStatus(Channel channel, Locale locale)", e);
            TRACE.errorT("getChannelStatus(Channel channel, Locale locale)", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0049", "Cannot retrieve status for channel {0}. Received exception: {1}", channel.getChannelName(), e.getMessage());
            cs = csf.createChannelStatus(channel, ChannelState.ERROR, "Cannot retrieve status for this channel due to: " + e.getMessage());
            TRACE.exiting("getChannelStatus(Channel channel, Locale locale)", new Object[]{cs});
            return cs;
        }
        TRACE.exiting("getChannelStatus(Channel channel, Locale locale)", new Object[]{cs});
        return cs;
    }

    public String localizeString(String str, Locale locale) throws LocalizationNotPossibleException {
        return this.localizer.localizeString(str, locale);
    }
}

