/*
 * $Id: URIBuilder.java 23505 2011-12-20 08:20:49Z mike.schilling $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package com.mulesoft.adapter;

import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Callable;

import com.sforce.soap.partner.fault.ApiFault;

public abstract class Component implements Callable
{
    private String contentType;

    @Override
    public Object onCall(MuleEventContext eventContext) throws Exception
    {
        MuleMessage msg;
        MuleMessage inputMsg = eventContext.getMessage();
        contentType = "text/html";

        try
        {
            msg =  doOnCall(inputMsg);
        }
        catch (Exception ex)
        {
            Throwable e = ex;
            String message = "An error occurred: "+e.toString();
            while (true)
            {
                if (e.getMessage() != null)
                {
                    message = e.getMessage();
                    break;
                }
                else if (e instanceof ApiFault)
                {
                    ApiFault fault = (ApiFault) e;
                    if (fault.getExceptionMessage() != null)
                    {
                        message = fault.getExceptionMessage();
                        break;
                    }
                }
                if (e.getCause() == null)
                {
                    break;
                }
                e = e.getCause();
            }
            msg = new DefaultMuleMessage("{\"error\": \""+message+"\"}", inputMsg.getMuleContext());
            msg.setOutboundProperty("http.status", 500);
        }
        msg.setOutboundProperty("content-type", contentType);
        return msg;
    }

    public void setContentType(String contentType)
    {
        this.contentType = contentType;
    }

    protected abstract MuleMessage doOnCall(MuleMessage message) throws Exception;
}
