/*
 * $Id: URIBuilder.java 23505 2011-12-20 08:20:49Z mike.schilling $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package com.mulesoft.adapter;

import org.mule.api.MuleMessage;

import com.mulesoft.utils.salesforce.SalesforceCallback;
import com.mulesoft.utils.salesforce.WsdlGenerator;
import com.mulesoft.utils.wsdl.OperationType;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PerformGeneration extends Component
{
    @Override
    public MuleMessage doOnCall(MuleMessage message) throws Exception
    {
        Map<String, Object> params = (Map<String, Object>) message.getPayload();
        String sessionId = (String) params.get("sessionId");
        if (sessionId == null)
        {
            throw new Exception("No SalesForce session was specified.");
        }

        Set<String> types = new HashSet<String>((List<String>) params.get("types"));
        if (types == null)
        {
            throw new Exception("Failed to accces parameter types.");
        }
        List<String> operations = (List<String>) params.get("operations");
        if (operations == null)
        {
            throw new Exception("Failed to accces parameter operations.");
        }
        Set<OperationType> ops = new HashSet<OperationType>();
        for (String operation: operations)
        {
            ops.add(OperationType.valueOf(operation.toUpperCase()));
        }

        SalesforceCallback callback = PerformLogin.getCallback(sessionId);
        if (callback == null)
        {
            throw new Exception("Unable to find Salesforce session for current session.");
        }
        WsdlGenerator gen = new WsdlGenerator(callback);
        gen.addOperations(ops, types);
        StringWriter writer = new StringWriter();
        gen.generateWsdl(writer);
        message.setPayload(writer.toString());
        setContentType("text/xml");
        message.setOutboundProperty("Content-Disposition", "attachment; filename=\"doc.wsdl\"");
        return message;
    }
}
