/*
 * $Id: URIBuilder.java 23505 2011-12-20 08:20:49Z mike.schilling $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package com.mulesoft.adapter;

import com.mulesoft.adapter.cli.WsdlGenerationMain;
import com.mulesoft.utils.salesforce.SalesforceCallback;
import com.mulesoft.utils.wsdl.OperationType;

import java.util.*;

import org.apache.commons.httpclient.Cookie;
import org.mule.api.MuleMessage;
import org.mule.transport.http.HttpConstants;
import org.mule.util.UUID;

public class PerformLogin extends Component
{
    private static Map<String, Session> sessions = new HashMap();
    private static Object lock = new Object();

    private static long sessionTimeout = 30 * 60 * 1000;
    private static long cleanupInterval = 5 * 60 * 1000;
    private static Timer cleanupThread;
    static
    {
        cleanupThread = new Timer("sessionCleanup", true);
        cleanupThread.schedule(new SessionCleaner(), 0, cleanupInterval);
    }
    private String TITLE_SIZE = "h4";
    private int numColumns = 5;


    @Override
    public MuleMessage doOnCall(MuleMessage message) throws Exception {
        final Map<String, String> payload = (Map<String, String>) message.getPayload();
        final WsdlGenerationMain gen = new WsdlGenerationMain(
                        payload.get("username"),
                        payload.get("password"),
                        payload.get("token"));
        gen.connect();
        final String sessionId = UUID.getUUID();
        synchronized (lock)
        {
            sessions.put(sessionId, new Session(gen));
        }
        final List<String> types = new LinkedList<String>();
        for (final String type : gen.getTypeNames()) {
            types.add("\""+type+"\"");
        }
        final List<String> operations = new LinkedList<String>();
        for (final OperationType operationType : OperationType.values()) {
            operations.add("\""+operationType.name()+"\"");
        }
        message.setPayload("{\"operations\":"+operations+", \"types\": "+types+", \"sessionId\": \""+sessionId+"\"}");
        return message;
    }

    static SalesforceCallback getCallback(String user)
    {
        synchronized (lock)
        {
            Session session = sessions.get(user);
            return session == null ? null : session.getCallback();
        }
    }
    
    private static class SessionCleaner extends TimerTask
    {
        @Override
        public void run()
        {
            synchronized (lock)
            {
                try
                {
                    for (String id: new HashSet<String>(sessions.keySet()))
                    {
                        Session session = sessions.get(id);
                        if (session != null && (session.getCreated() - System.currentTimeMillis() > sessionTimeout))
                        {
                            sessions.remove(id);
                        }
                    }
                }
                catch (Exception ex)
                {
                    ;
                }
            }
        }
    }
    
    private class Session
    {
        private long created;
        private SalesforceCallback callback;

        private Session(SalesforceCallback callback)
        {
            this.callback = callback;
            this.created = System.currentTimeMillis();
        }

        public long getCreated()
        {
            return created;
        }

        public SalesforceCallback getCallback()
        {
            return callback;
        }
    }
    
}
