/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.adapter.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Parser
{
    private Map<Character, String> arguments;
    private Map<String, String> defaults;

    public Parser()
    {
        arguments = new HashMap<Character, String>();
        defaults = new HashMap<String, String>();
    }
    
    public void addArgument(String arg, char flag)
    {
        arguments.put(flag, arg);
    }

    public void addArgument(String arg, char flag, String defaultValue)
    {
        arguments.put(flag, arg);
        defaults.put(arg, defaultValue);
    }
    
    public ParsedArgs parse(String[] args)
    {
        return new ParsedArgs().parse(args);    
    }
    
    public class ParsedArgs
    {
        private Map<String, String> flagValues;
        private List<String> unnamedArgs;
        private String illegalArgument;

        public ParsedArgs()
        {
            flagValues = new HashMap<String, String>();
            unnamedArgs = new ArrayList<String>();
        }

        public List<String> getUnnamedArguments()
        {
            return unnamedArgs;
        }
        
        public String getNamedArgument(String argumentName)
        {
            return flagValues.get(argumentName);
        }

        public String getIllegalArgument()
        {
            return illegalArgument;
        }

        protected ParsedArgs parse(String[] args)
        {
            for (Map.Entry<String, String> entry : defaults.entrySet())
            {
                flagValues.put(entry.getKey(), entry.getValue());   
            }
            boolean doneWithFlags = false;
            for (int i = 0; i < args.length; )
            {
                String str = args[i];
                if (doneWithFlags)
                {
                    unnamedArgs.add(str);
                    i++;
                }
                else
                {
                    if (!str.startsWith("-"))
                    {
                        doneWithFlags = true;
                        continue;
                    }
                    if (str.length() == 1)
                    {
                        illegalArgument = str;
                        break;
                    }
                    char flag = str.charAt(1);
                    String argName = arguments.get(flag);
                    if (argName == null)
                    {
                        illegalArgument = str;
                        break;
                    }
                    String value;
                    if (str.length() > 2)
                    {
                        value = str.substring(2);
                        i++;
                    }
                    else
                    {
                        if (i == args.length - 1)
                        {
                            illegalArgument = str;
                            break;
                        }
                        value = args[i+1];
                        i += 2;
                    }
                    flagValues.put(argName, value);
                }
            }
            
            return this;
        }
    }
}
