/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.adapter.cli;

import com.mulesoft.utils.salesforce.SalesforceCallback;
import com.mulesoft.utils.salesforce.TypeGenerator;
import com.mulesoft.utils.salesforce.WsdlGenerator;
import com.mulesoft.utils.wsdl.OperationType;
import com.mulesoft.utils.wsdl.Wsdl;
import com.mulesoft.utils.xml.Element;
import com.mulesoft.utils.xml.Formatter;
import com.sforce.async.AsyncApiException;
import com.sforce.async.RestConnection;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeLayoutResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

public class WsdlGenerationMain implements SalesforceCallback
{
    private String username;
    private String password;
    private String securityToken;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    
    private String urlString = "https://login.salesforce.com:443/services/Soap/u/23.0";
    private String wsdlUrl = "https://login.salesforce.com/soap/wsdl.jsp?type=*";
    private PartnerConnection connection;
    private RestConnection restConnection;

    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String SECURITY_TOKEN = "securityToken";
    private static final String PROXY_USERNAME = "proxyUsername";
    private static final String PROXY_PASSWORD = "proxyPassword";
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";

    /**
     * Command-line wrapper to create a WsdlReader object and use it to read the Wsdl.  See osage() for the arguments
     */
    public static void main(String[] args) throws Exception
    {
        try
        {
            Parser parser = new Parser(); 
            parser.addArgument(USERNAME, 'u');
            parser.addArgument(PASSWORD, 'p');
            parser.addArgument(SECURITY_TOKEN, 's');
            parser.addArgument(PROXY_HOST, 'H');
            parser.addArgument(PROXY_PORT, '#');
            parser.addArgument(PROXY_USERNAME, 'U');
            parser.addArgument(PROXY_PASSWORD, 'P');
            Parser.ParsedArgs parsed = parser.parse(args);
            if (parsed.getIllegalArgument() != null)
            {
                usage(true);
            }
            String username = parsed.getNamedArgument(USERNAME);
            String password = parsed.getNamedArgument(PASSWORD);
            String token = parsed.getNamedArgument(SECURITY_TOKEN);
            if (username == null || password == null || token == null)
            {
                usage(true);   
            }
            WsdlGenerationMain main = new WsdlGenerationMain(username, password, token);
            String proxyHost = parsed.getNamedArgument(PROXY_HOST);
            if (proxyHost != null)
            {
                String proxyPortString = parsed.getNamedArgument(PROXY_PORT);
                String proxyUsername = parsed.getNamedArgument(PROXY_USERNAME);
                String proxyPassword = parsed.getNamedArgument(PROXY_PASSWORD);
                if (proxyPortString == null || proxyUsername == null || proxyPassword == null)
                {
                    usage(true);
                } 
                int proxyPort = -1;
                try
                {
                    proxyPort = Integer.parseInt(proxyPortString);
                }
                catch (Exception ex)
                {
                    usage(true);
                }
                main.setupProxy(proxyHost, proxyPort, proxyUsername, proxyPassword);
            }
            main.connect();

            WsdlGenerator wsdlGen = new WsdlGenerator(main);
            Set<OperationType> ops = new HashSet<OperationType>();
            Set<String> types = new HashSet<String>();
            ops.add(OperationType.CREATE);
            ops.add(OperationType.DELETE);
            ops.add(OperationType.QUERY);
            ops.add(OperationType.UPSERT);
            for (String typeName: parsed.getUnnamedArguments())
            {
                types.add(typeName);
            }
            wsdlGen.addOperations(ops, types);
            wsdlGen.generateWsdl(new FileWriter("c:/temp/wsdl.gen"));
        }
        catch (Exception ex)
        {
            System.err.println("Unable to generate WSDL: " + ex.getMessage());
        }
    }

    /**
     * Print a useage message, optionally exiting afterward
     */
    public static void usage(boolean exit)
    {
        System.err.println("Usage: WsdlGenerator -u username -p password -s securityToken [-H proxyHost -# proxyPort -U proxyUsername -P proxyPassword] type1 [type2 ...]");
        if (exit)
        {
            System.exit(-1);
        }
    }
    /**
     * Creates a new Salesforce WSDL reader
     *
     * @param username      Username used to initialize the session
     * @param password      Password used to authenticate the user
     * @param securityToken User's security securityToken
     */
    public WsdlGenerationMain(String username, String password, String securityToken) throws MalformedURLException
    {
        this.username = username;
        this.password = password;
        this.securityToken = securityToken;
    }

    /**
     * Setup the  information required when connecting to salesforce via a proxy.
     */
    public void setupProxy(String proxyHost, int proxyPort, String proxyUsername, String proxyPassword)
    {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    /**
     * Connect to Salesforce
     */
    public void connect() throws ConnectionException, MalformedURLException, AsyncApiException
    {
        ConnectorConfig connectorConfig = createConnectorConfig();
        connection = Connector.newConnection(connectorConfig);
        LoginResult loginResult = connection.login(connection.getConfig().getUsername(), connection.getConfig().getPassword());
        connection.getSessionHeader().setSessionId(loginResult.getSessionId());
        connection.getConfig().setServiceEndpoint(loginResult.getServerUrl());
        connection.getConfig().setSessionId(loginResult.getSessionId());
        String restEndpoint = "https://" + (new URL(connectorConfig.getServiceEndpoint())).getHost() + "/services/async/23.0";
        connectorConfig.setRestEndpoint(restEndpoint);
        restConnection = new RestConnection(connectorConfig);
    }

    public List<String> getTypeNames() throws ConnectionException
    {
        ArrayList<String> typeNames = new ArrayList<String>();
        DescribeGlobalResult result = connection.describeGlobal();
        for ( DescribeGlobalSObjectResult so : result.getSobjects())
        {
            /******
            if (so.getCustom())
            {
                System.out.println("!!!Custom: " + so.getName());
            }
             *******/
            typeNames.add(so.getName());
        }
        return typeNames;
    }

    public DescribeSObjectResult describeSObject(String name) throws ConnectionException
    {
        return connection.describeSObject(name);
    }

    public DescribeLayoutResult describeLayout(String name) throws ConnectionException
    {
        return connection.describeLayout(name, new String[0]);
    }

    private InputStream getFromURL(String url) throws Exception
    {
        return restConnection.doHttpGet(new URL(url));
    }


    /*****
    public Document readWsdl() throws Exception
    {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputStream stream = getFromURL(wsdlUrl);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c;
        while ((c = stream.read()) > 0)
        {
            baos.write(c);
        }
        stream.close();
        return builder.parse(new ByteArrayInputStream(baos.toByteArray()));
    }
     *****/

    private ConnectorConfig createConnectorConfig()
    {
        ConnectorConfig config = new ConnectorConfig();
        config.setUsername(username);
        config.setPassword(password + securityToken);
        config.setAuthEndpoint(urlString.toString());
        config.setServiceEndpoint(urlString.toString());
        config.setManualLogin(true);
        config.setCompression(false);
        
        if (proxyHost != null)
        {
            config.setProxy(proxyHost, proxyPort);
            config.setProxyUsername(proxyUsername);
            config.setProxyPassword(proxyPassword);
        }
        return config;
    }
}
