/*
 * $Id: URIBuilder.java 23505 2011-12-20 08:20:49Z mike.schilling $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package com.mulesoft.utils.salesforce;

import com.mulesoft.utils.wsdl.OperationType;
import com.mulesoft.utils.wsdl.Wsdl;
import com.mulesoft.utils.xml.Element;
import com.mulesoft.utils.xml.Formatter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WsdlGenerator
{
    private SalesforceCallback callback;
    private Set<String> opTypes = new HashSet<String>();
    private Set<OperationType> opOps = new HashSet<OperationType>();
    
    public WsdlGenerator(SalesforceCallback callback)
    {
        this.callback = callback;
    }

    public void addOperations(Set<OperationType> operations, Set<String> typeNames)
    {
        opOps = new HashSet<OperationType>(operations);
        opTypes = new HashSet<String>(typeNames);
    }
    
    public void generateWsdl(Writer output) throws Exception
    {
        Wsdl wsdl = new Wsdl();
        TypeGenerator typegen = new TypeGenerator(callback);
        
        for (String typeName : new HashSet<String>(opTypes))
        {
            typegen.generateType(typeName);
            for (OperationType op : opOps)
            {
                wsdl.addOperation(op,  typeName);
            }
        }

        for (Map.Entry<String, Element> entry : typegen.getTypes().entrySet())
        {
            wsdl.addType(entry.getKey(), entry.getValue());
        }

        Formatter formatter = new Formatter(output, 4);
        wsdl.generate().output(formatter);
        formatter.close();
    }
}
