/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.schema;

import com.mulesoft.utils.wsdl.Wsdl;
import com.mulesoft.utils.xml.Element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComplexTypes
{
    public static List<Element> getComplexTypes(String ns)
    {
        if (ns.equals(Wsdl.FNS))
        {
            return getFaultTypes();
        }
        else if (ns.equals(Wsdl.ENS))
        {
            return getSObjectTypes();
        }
        else if (ns.equals(Wsdl.TNS))
        {
            return getMainTypes();
        }
        else
        {
            return new ArrayList<Element>();
        }
    }

    private static List<Element> getSObjectTypes()
    {
        List<Element> elms = new ArrayList<Element>();
        elms.addAll(getSObject());
        elms.addAll(getAggregateResult());
        return elms;
    }

    private static List<? extends Element> getAggregateResult()
    {
        return getSequence("ens", "AggregateResult", "ens:sObject", null, new SequenceCallback()
        {
            @Override
            void call(Element sequence)
            {
                sequence.addChild(createElement("fieldsToNull", "xsd:string", "nillable", "true", "minOccurs", "0", "maxOccurs", "unbounded"));
                sequence.addChild(createElement("Id", "tns:ID", "nillable", "true"));
            }
        });
    }

    private static List<? extends Element> getSObject()
    {
        return getSequence("ens", "sObject", null, null, new SequenceCallback()
        {
            @Override
            void call(Element sequence)
            {
                sequence.addChild(createElement("fieldsToNull", "xsd:string", "nillable", "true", "minOccurs", "0", "maxOccurs", "unbounded"));
                sequence.addChild(new Element("any").addAttr("namespace", "##targetNamespace").addAttr("minOccurs", "0")
                        .addAttr("maxOccurs", "unbounded").addAttr("processContents", "lax"));
            }
        });
    }

    private static List<Element> getMainTypes()
    {
        List<Element> elms = new ArrayList<Element>();    
        elms.addAll(getError());
        elms.addAll(getSaveResult());
        elms.addAll(getDeleteResult());
        //elms.add(getQueryResult());
        elms.addAll(getUpsertResult());
        return elms;
    }

    private static Collection<? extends Element> getDeleteResult()
    {
        return getSequence("tns", "DeleteResult", null, null, new SequenceCallback()
        {
            @Override
            void call(Element sequence)
            {
                sequence.addChild(createElement("errors", "tns:Error","minOccurs", "0", "maxOccurs", "unbounded",
                                  "nillable", "true"));
                sequence.addChild(createElement("id", "tns:ID", "nillable", "true"));
                sequence.addChild(createElement("success", "xsd:boolean"));
            }
        });
    }

    private static Collection<? extends Element> getSaveResult()
    {
        return getSequence("tns", "SaveResult", null, null, new SequenceCallback()
        {
            @Override
            void call(Element sequence)
            {
                sequence.addChild(createElement("errors", "tns:Error","minOccurs", "0", "maxOccurs", "unbounded"));
                sequence.addChild(createElement("id", "tns:ID", "nillable", "true"));
                sequence.addChild(createElement("success", "xsd:boolean"));
            }
        });
    }

    private static Collection<? extends Element> getUpsertResult()
    {
        return getSequence("tns", "UpsertResult", null, null, new SequenceCallback()
        {
            @Override
            void call(Element sequence)
            {
                sequence.addChild(createElement("created", "xsd:boolean"));
                sequence.addChild(createElement("errors", "tns:Error","minOccurs", "0", "maxOccurs", "unbounded"));
                sequence.addChild(createElement("id", "tns:ID", "nillable", "true"));
                sequence.addChild(createElement("success", "xsd:boolean"));
            }
        });
    }


    public static String getQueryTypeName(String resultType)
    {
        return resultType + "QueryResult";   
    }
    
    public static Element getQueryResult(String resultTypePrefix, String resultType)
    {
        final String queryTypeName;
        final String rowType;
        
        if (resultType == null)
        {
            queryTypeName = "QueryResult";
            rowType = "ens:sObject";
        }
        else
        {
            queryTypeName = getQueryTypeName(resultType);
            rowType = resultTypePrefix + ":" + resultType;
        }
        
        return getSequence("tns", queryTypeName, null, null, new SequenceCallback()
        {
            @Override
            void call(Element sequence)
            {
                sequence.addChild(createElement("done", "xsd:boolean"));
                sequence.addChild(createElement("queryLocator", "tns:QueryLocator", "nillable", "true"));
                sequence.addChild(createElement("records", rowType, "minOccurs", "0", 
                                                "maxOccurs", "unbounded", "nillable", "true"));
                sequence.addChild(createElement("size", "xsd:int"));
            }
        }).get(0);
    }

    public static Element getSubscribeResponse(String resultTypePrefix, String resultType)
    {
        Element top = new Element("element").addAttr("name", "subscribe" + resultType + "Response");
        Element elm = new Element("complexType", top);
        elm = new Element("sequence", elm);
        elm.addChild(new Element("element").addAttr("name", "createdDate").addAttr("type", "xsd:date"));
        elm.addChild(new Element("element").addAttr("name", "channel").addAttr("type", "xsd:string"));
        elm.addChild(new Element("element").addAttr("name", "type").addAttr("type", "xsd:string"));
        elm.addChild(new Element("element").addAttr("name", "sObjects").addAttr("type", resultTypePrefix + ":" + resultType)
                        .addAttr("minOccurs", "0").addAttr("maxOccurs", "unbounded"));

        return top;
    }

    public static Element getQueryResult()
    {
        return getQueryResult(null, null);
    }

    private static List<? extends Element> getError()
    {
        return getSequence("tns", "Error", null, null, new SequenceCallback()
        {
            @Override
            void call(Element sequence)
            {
                sequence.addChild(createElement("fields", "xsd:string", "nillable", "true", "minOccurs", "0", "maxOccurs", "unbounded"));
                sequence.addChild(createElement("message", "xsd:string"));
                sequence.addChild(createElement("statusCode", "tns:StatusCode"));
            }
        });
    }

    private static List<Element> getFaultTypes()
    {
        List<Element> elms = new ArrayList<Element>();
        elms.addAll(getApiFault());
        elms.addAll(getApiQueryFault());
        elms.addAll(getLoginFault());
        elms.addAll(getInvalidQueryLocatorFault());
        elms.addAll(getInvalidNewPasswordFault());
        elms.addAll(getInvalidIdFault());
        elms.addAll(getUnexpectedErrorFault());
        elms.addAll(getInvalidFieldFault());
        elms.addAll(getInvalidSObjectFault());
        elms.addAll(getMalformedQueryFault());
        elms.addAll(getMalformedSearchFault());
        return elms;
    }

    private static List<Element> getApiFault()
    {
        return getSequence("fns", "ApiFault", null, "fault", "exceptionCode", "fns:ExceptionCode", "exceptionMessage", "xsd:string");
    }

    private static List<Element> getApiQueryFault()
    {
        return getSequence("fns", "ApiQueryFault", "fns:ApiFault", null, "row", "xsd:int", "column", "xsd:int");
    }

    private static List<Element> getLoginFault()
    {
        return getSequence("fns", "LoginFault", "fns:ApiFault", "LoginFault");
    }

    private static List<Element> getInvalidQueryLocatorFault()
    {
        return getSequence("fns", "InvalidQueryLocatorFault", "fns:ApiFault", "InvalidQueryLocatorFault");
    }

    private static List<Element> getInvalidNewPasswordFault()
    {
        return getSequence("fns", "InvalidNewPasswordFault", "fns:ApiFault", "InvalidNewPasswordFault");
    }

    private static List<Element> getInvalidIdFault()
    {
        return getSequence("fns", "InvalidIdFault", "fns:ApiFault", "InvalidIdFault");
    }

    private static List<Element> getUnexpectedErrorFault()
    {
        return getSequence("fns", "UnexpectedErrorFault", "fns:ApiFault", "UnexpectedErrorFault");
    }

    private static List<Element> getInvalidFieldFault()
    {
        return getSequence("fns", "InvalidFieldFault", "fns:ApiFault", "InvalidFieldFault");
    }

    private static List<Element> getInvalidSObjectFault()
    {
        return getSequence("fns", "InvalidSObjectFault", "fns:ApiFault", "InvalidSObjectFault");
    }

    private static List<Element> getMalformedQueryFault()
    {
        return getSequence("fns", "MalformedQueryFault", "fns:ApiFault", "MalformedQueryFault");
    }

    private static List<Element> getMalformedSearchFault()
    {
        return getSequence("fns", "MalformedSearchFault", "fns:ApiFault", "MalformedSearchFault");
    }

    private static List<Element> getSequence(String typePrefix, String typeName, String baseType, String element, String ... values)
    {
        List<Element> elms = new ArrayList<Element>();
        Element elm = new Element("complexType").addAttr("name", typeName);
        Element root = elm;
        Element child;
        if (baseType != null)
        {
            child = new Element("complexContent");
            root.addChild(child);
            root = child;
            child = new Element("extension").addAttr("base", baseType);
            root.addChild(child);
            root = child;
        }
        if (values.length > 0)
        {
            Element sequence = new Element("sequence");
            root.addChild(sequence);
        
            for (int i = 0; i < values.length; )
            {
                sequence.addChild(new Element("element").addAttr("name", values[i++]).addAttr("type", values[i++]));
            }
        }
        elms.add(elm);
        if (element != null)
        {
            elms.add(new Element("element").addAttr("name", element).addAttr("type", typePrefix + ":" + typeName));
        }

        return elms;
    }

    private static List<Element> getSequence(String typePrefix, String typeName, String baseType, String element, SequenceCallback callback)
    {
        List<Element> elms = new ArrayList<Element>();
        Element elm = new Element("complexType").addAttr("name", typeName);
        Element root = elm;
        Element child;
        if (baseType != null)
        {
            child = new Element("complexContent");
            root.addChild(child);
            root = child;
            child = new Element("extension").addAttr("base", baseType);
            root.addChild(child);
            root = child;
        }
        Element sequence = new Element("sequence");
        root.addChild(sequence);
        callback.call(sequence);
        elms.add(elm);
        if (element != null)
        {
            elms.add(new Element("element").addAttr("name", element).addAttr("type", typePrefix + ":" + typeName));
        }

        return elms;
    }
    
    private static Element createElement(String name, String type, String ... others)
    {
        Element elm = new Element("element").addAttr("name", name).addAttr("type", type);
        for (int i = 0; i < others.length; )
        {
            elm.addAttr(others[i++], others[i++]);
        }
        return elm;
    }


    static abstract class SequenceCallback
    {                                  
        abstract void call(Element elm);
    }
}
