/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.schema;



import com.mulesoft.utils.wsdl.Wsdl;
import com.mulesoft.utils.xml.Element;
import java.util.ArrayList;
import java.util.List;

public class SimpleTypes
{
    public static List<Element> getSimpleTypes(String ns)
    {
        if (ns.equals(Wsdl.TNS))
        {
            return getNonFaultTypes();
        }
        else if (ns.equals(Wsdl.FNS))
        {
            return getFaultTypes();
        }
        else
        {
            return new ArrayList<Element>();
        }
    }

    private static List<Element> getFaultTypes()
    {
        List<Element> elms = new ArrayList<Element>();
        elms.add(createExceptionCode());
        elms.add(createFaultCode());
        return elms;
    }

    private static List<Element> getNonFaultTypes()
    {
        List<Element> elms = new ArrayList<Element>();
        elms.add(createID());
        elms.add(createDebugLevel());
        elms.add(createEmailPriority());
        elms.add(createFieldType());
        elms.add(createLayoutComponentType());
        elms.add(createQueryLocator());
        elms.add(createSoapType());
        elms.add(createStatusCode());
        return elms;
    }

    private static Element createID()
    {
        Element elm = new Element("simpleType").addAttr("name", "ID");
        Element restriction = new Element("restriction").addAttr("base", "xsd:string");
        elm.addChild(restriction);
        restriction.
                addChild(new Element("length").addAttr("value", "18")).
                addChild(new Element("pattern").addAttr("value", "[a-zA-Z0-9]{18}"));
        return elm;
    }
    
    private static Element createQueryLocator()
    {
        return createRestriction("QueryLocator", "xsd:string");
    }

    private static Element createStatusCode()
    {
        return createRestriction("StatusCode", "xsd:string",
                "ALL_OR_NONE_OPERATION_ROLLED_BACK",
                "ALREADY_IN_PROCESS",
                "ASSIGNEE_TYPE_REQUIRED",
                "BAD_CUSTOM_ENTITY_PARENT_DOMAIN",
                "BCC_NOT_ALLOWED_IF_BCC_COMPLIANCE_ENABLED",
                "CANNOT_CASCADE_PRODUCT_ACTIVE",
                "CANNOT_CHANGE_FIELD_TYPE_OF_APEX_REFERENCED_FIELD",
                "CANNOT_CREATE_ANOTHER_MANAGED_PACKAGE",
                "CANNOT_DEACTIVATE_DIVISION",
                "CANNOT_DELETE_LAST_DATED_CONVERSION_RATE",
                "CANNOT_DELETE_MANAGED_OBJECT",
                "CANNOT_DISABLE_LAST_ADMIN",
                "CANNOT_ENABLE_IP_RESTRICT_REQUESTS",
                "CANNOT_INSERT_UPDATE_ACTIVATE_ENTITY",
                "CANNOT_MODIFY_MANAGED_OBJECT",
                "CANNOT_RENAME_APEX_REFERENCED_FIELD",
                "CANNOT_RENAME_APEX_REFERENCED_OBJECT",
                "CANNOT_REPARENT_RECORD",
                "CANNOT_UPDATE_CONVERTED_LEAD",
                "CANT_DISABLE_CORP_CURRENCY",
                "CANT_UNSET_CORP_CURRENCY",
                "CHILD_SHARE_FAILS_PARENT",
                "CIRCULAR_DEPENDENCY",
                "COMMUNITY_NOT_ACCESSIBLE",
                "CUSTOM_CLOB_FIELD_LIMIT_EXCEEDED",
                "CUSTOM_ENTITY_OR_FIELD_LIMIT",
                "CUSTOM_FIELD_INDEX_LIMIT_EXCEEDED",
                "CUSTOM_INDEX_EXISTS",
                "CUSTOM_LINK_LIMIT_EXCEEDED",
                "CUSTOM_TAB_LIMIT_EXCEEDED",
                "DELETE_FAILED",
                "DELETE_REQUIRED_ON_CASCADE",
                "DEPENDENCY_EXISTS",
                "DUPLICATE_CASE_SOLUTION",
                "DUPLICATE_COMM_NICKNAME",
                "DUPLICATE_CUSTOM_ENTITY_DEFINITION",
                "DUPLICATE_CUSTOM_TAB_MOTIF",
                "DUPLICATE_DEVELOPER_NAME",
                "DUPLICATE_EXTERNAL_ID",
                "DUPLICATE_MASTER_LABEL",
                "DUPLICATE_SENDER_DISPLAY_NAME",
                "DUPLICATE_USERNAME",
                "DUPLICATE_VALUE",
                "EMAIL_NOT_PROCESSED_DUE_TO_PRIOR_ERROR",
                "EMPTY_SCONTROL_FILE_NAME",
                "ENTITY_FAILED_IFLASTMODIFIED_ON_UPDATE",
                "ENTITY_IS_ARCHIVED",
                "ENTITY_IS_DELETED",
                "ENTITY_IS_LOCKED",
                "ERROR_IN_MAILER",
                "FAILED_ACTIVATION",
                "FIELD_CUSTOM_VALIDATION_EXCEPTION",
                "FIELD_FILTER_VALIDATION_EXCEPTION",
                "FIELD_INTEGRITY_EXCEPTION",
                "FILTERED_LOOKUP_LIMIT_EXCEEDED",
                "HTML_FILE_UPLOAD_NOT_ALLOWED",
                "IMAGE_TOO_LARGE",
                "INACTIVE_OWNER_OR_USER",
                "INSUFFICIENT_ACCESS_ON_CROSS_REFERENCE_ENTITY",
                "INSUFFICIENT_ACCESS_OR_READONLY",
                "INVALID_ACCESS_LEVEL",
                "INVALID_ARGUMENT_TYPE",
                "INVALID_ASSIGNEE_TYPE",
                "INVALID_ASSIGNMENT_RULE",
                "INVALID_BATCH_OPERATION",
                "INVALID_CONTENT_TYPE",
                "INVALID_CREDIT_CARD_INFO",
                "INVALID_CROSS_REFERENCE_KEY",
                "INVALID_CROSS_REFERENCE_TYPE_FOR_FIELD",
                "INVALID_CURRENCY_CONV_RATE",
                "INVALID_CURRENCY_CORP_RATE",
                "INVALID_CURRENCY_ISO",
                "INVALID_DATA_CATEGORY_GROUP_REFERENCE",
                "INVALID_DATA_URI",
                "INVALID_EMAIL_ADDRESS",
                "INVALID_EMPTY_KEY_OWNER",
                "INVALID_FIELD",
                "INVALID_FIELD_FOR_INSERT_UPDATE",
                "INVALID_FIELD_WHEN_USING_TEMPLATE",
                "INVALID_FILTER_ACTION",
                "INVALID_GOOGLE_DOCS_URL",
                "INVALID_ID_FIELD",
                "INVALID_INET_ADDRESS",
                "INVALID_LINEITEM_CLONE_STATE",
                "INVALID_MASTER_OR_TRANSLATED_SOLUTION",
                "INVALID_MESSAGE_ID_REFERENCE",
                "INVALID_OPERATION",
                "INVALID_OPERATOR",
                "INVALID_OR_NULL_FOR_RESTRICTED_PICKLIST",
                "INVALID_PARTNER_NETWORK_STATUS",
                "INVALID_PERSON_ACCOUNT_OPERATION",
                "INVALID_READ_ONLY_USER_DML",
                "INVALID_SAVE_AS_ACTIVITY_FLAG",
                "INVALID_SESSION_ID",
                "INVALID_SETUP_OWNER",
                "INVALID_STATUS",
                "INVALID_TYPE",
                "INVALID_TYPE_FOR_OPERATION",
                "INVALID_TYPE_ON_FIELD_IN_RECORD",
                "IP_RANGE_LIMIT_EXCEEDED",
                "LICENSE_LIMIT_EXCEEDED",
                "LIGHT_PORTAL_USER_EXCEPTION",
                "LIMIT_EXCEEDED",
                "MALFORMED_ID",
                "MANAGER_NOT_DEFINED",
                "MASSMAIL_RETRY_LIMIT_EXCEEDED",
                "MASS_MAIL_LIMIT_EXCEEDED",
                "MAXIMUM_CCEMAILS_EXCEEDED",
                "MAXIMUM_DASHBOARD_COMPONENTS_EXCEEDED",
                "MAXIMUM_HIERARCHY_LEVELS_REACHED",
                "MAXIMUM_SIZE_OF_ATTACHMENT",
                "MAXIMUM_SIZE_OF_DOCUMENT",
                "MAX_ACTIONS_PER_RULE_EXCEEDED",
                "MAX_ACTIVE_RULES_EXCEEDED",
                "MAX_APPROVAL_STEPS_EXCEEDED",
                "MAX_FORMULAS_PER_RULE_EXCEEDED",
                "MAX_RULES_EXCEEDED",
                "MAX_RULE_ENTRIES_EXCEEDED",
                "MAX_TASK_DESCRIPTION_EXCEEEDED",
                "MAX_TM_RULES_EXCEEDED",
                "MAX_TM_RULE_ITEMS_EXCEEDED",
                "MERGE_FAILED",
                "MISSING_ARGUMENT",
                "MIXED_DML_OPERATION",
                "NONUNIQUE_SHIPPING_ADDRESS",
                "NO_APPLICABLE_PROCESS",
                "NO_ATTACHMENT_PERMISSION",
                "NO_INACTIVE_DIVISION_MEMBERS",
                "NO_MASS_MAIL_PERMISSION",
                "NUMBER_OUTSIDE_VALID_RANGE",
                "NUM_HISTORY_FIELDS_BY_SOBJECT_EXCEEDED",
                "OPTED_OUT_OF_MASS_MAIL",
                "OP_WITH_INVALID_USER_TYPE_EXCEPTION",
                "PACKAGE_LICENSE_REQUIRED",
                "PORTAL_NO_ACCESS",
                "PORTAL_USER_ALREADY_EXISTS_FOR_CONTACT",
                "PRIVATE_CONTACT_ON_ASSET",
                "RECORD_IN_USE_BY_WORKFLOW",
                "REQUEST_RUNNING_TOO_LONG",
                "REQUIRED_FEATURE_MISSING",
                "REQUIRED_FIELD_MISSING",
                "SELF_REFERENCE_FROM_TRIGGER",
                "SHARE_NEEDED_FOR_CHILD_OWNER",
                "SINGLE_EMAIL_LIMIT_EXCEEDED",
                "STANDARD_PRICE_NOT_DEFINED",
                "STORAGE_LIMIT_EXCEEDED",
                "STRING_TOO_LONG",
                "TABSET_LIMIT_EXCEEDED",
                "TEMPLATE_NOT_ACTIVE",
                "TERRITORY_REALIGN_IN_PROGRESS",
                "TEXT_DATA_OUTSIDE_SUPPORTED_CHARSET",
                "TOO_MANY_APEX_REQUESTS",
                "TOO_MANY_ENUM_VALUE",
                "TRANSFER_REQUIRES_READ",
                "UNABLE_TO_LOCK_ROW",
                "UNAVAILABLE_RECORDTYPE_EXCEPTION",
                "UNDELETE_FAILED",
                "UNKNOWN_EXCEPTION",
                "UNSPECIFIED_EMAIL_ADDRESS",
                "UNSUPPORTED_APEX_TRIGGER_OPERATON",
                "UNVERIFIED_SENDER_ADDRESS",
                "USER_OWNS_PORTAL_ACCOUNT_EXCEPTION",
                "USER_WITH_APEX_SHARES_EXCEPTION",
                "WEBLINK_SIZE_LIMIT_EXCEEDED",
                "WRONG_CONTROLLER_TYPE"
        );
    }

    private static Element createFieldType()
    {
        return createRestriction("fieldType", "xsd:string",
                "string",
                "picklist",
                "multipicklist",
                "combobox",
                "reference",
                "base64",
                "boolean",
                "currency",
                "textarea",
                "int",
                "double",
                "percent",
                "phone",
                "id",
                "date",
                "datetime",
                "time",
                "url",
                "email",
                "encryptedstring",
                "datacategorygroupreference",
                "anyType"
                );
    }

    private static Element createSoapType()
    {
        return createRestriction("soapType", "xsd:string",
                "tns:ID",
                "xsd:base64Binary",
                "xsd:boolean",
                "xsd:double",
                "xsd:int",
                "xsd:string",
                "xsd:date",
                "xsd:dateTime",
                "xsd:time",
                "xsd:anyType");
    }


    private static Element createLayoutComponentType()
    {
        return createRestriction("layoutComponentType", "xsd:string",
                "Field",
                "Separator",
                "SControl",
                "EmptySpace");
    }

    private static Element createEmailPriority()
    {
        return createRestriction("EmailPriority", "xsd:string",
                "Highest",
                "High",
                "Normal",
                "Low",
                "Lowest");
    }

    private static Element createDebugLevel()
    {
        return createRestriction("DebugLevel", "xsd:string",
                "None",
                "DebugOnly");
    }

    private static Element createExceptionCode()
    {
        return createRestriction("ExceptionCode", "xsd:string", getExceptionCodes());
    }

    private static Element createFaultCode()
    {
        String[] errorCodes = getExceptionCodes();
        String[] faultCodes = new String[errorCodes.length];
        for (int i = 0 ; i < errorCodes.length; i++)
        {
            faultCodes[i] = "fns:" + errorCodes[i];
        }
        return createRestriction("FaultCode", "xsd:QName", faultCodes);
    }

    private static Element createRestriction(String name, String baseType, String ... values)
    {
        Element elm = new Element("simpleType").addAttr("name", name);
        Element restriction = new Element("restriction").addAttr("base", baseType);
        elm.addChild(restriction);
        for (String value : values)
        {
            restriction.addChild(new Element("enumeration").addAttr("value", value));
        }

        return elm;
    }
    
    private static String[] getExceptionCodes()
    {
        return new String[]
                {
                        "API_CURRENTLY_DISABLED",
                        "API_DISABLED_FOR_ORG",
                        "ARGUMENT_OBJECT_PARSE_ERROR",
                        "CANNOT_DELETE_OWNER",
                        "CANT_ADD_STANDADRD_PORTAL_USER_TO_TERRITORY",
                        "CANT_ADD_STANDARD_PORTAL_USER_TO_TERRITORY",
                        "CIRCULAR_OBJECT_GRAPH",
                        "CLIENT_NOT_ACCESSIBLE_FOR_USER",
                        "CLIENT_REQUIRE_UPDATE_FOR_USER",
                        "CUSTOM_METADATA_LIMIT_EXCEEDED",
                        "DATACLOUD_API_CLIENT_EXCEPTION",
                        "DATACLOUD_API_SERVER_BUSY_EXCEPTION",
                        "DATACLOUD_API_SERVER_EXCEPTION",
                        "DATACLOUD_API_UNAVAILABLE",
                        "DUPLICATE_ARGUMENT_VALUE",
                        "DUPLICATE_VALUE",
                        "EMAIL_BATCH_SIZE_LIMIT_EXCEEDED",
                        "EMAIL_TO_CASE_INVALID_ROUTING",
                        "EMAIL_TO_CASE_LIMIT_EXCEEDED",
                        "EMAIL_TO_CASE_NOT_ENABLED",
                        "EXCEEDED_ID_LIMIT",
                        "EXCEEDED_LEAD_CONVERT_LIMIT",
                        "EXCEEDED_MAX_SIZE_REQUEST",
                        "EXCEEDED_MAX_TYPES_LIMIT",
                        "EXCEEDED_QUOTA",
                        "FEED_NOT_ENABLED_FOR_OBJECT",
                        "FUNCTIONALITY_NOT_ENABLED",
                        "FUNCTIONALITY_TEMPORARILY_UNAVAILABLE",
                        "INACTIVE_OWNER_OR_USER",
                        "INACTIVE_PORTAL",
                        "INSUFFICIENT_ACCESS",
                        "INVALID_ASSIGNMENT_RULE",
                        "INVALID_BATCH_SIZE",
                        "INVALID_CLIENT",
                        "INVALID_CROSS_REFERENCE_KEY",
                        "INVALID_FIELD",
                        "INVALID_FILTER_LANGUAGE",
                        "INVALID_FILTER_VALUE",
                        "INVALID_ID_FIELD",
                        "INVALID_LOCALE_LANGUAGE",
                        "INVALID_LOCATOR",
                        "INVALID_LOGIN",
                        "INVALID_MULTIPART_REQUEST",
                        "INVALID_NEW_PASSWORD",
                        "INVALID_OPERATION",
                        "INVALID_OPERATION_WITH_EXPIRED_PASSWORD",
                        "INVALID_PAGING_OPTION",
                        "INVALID_QUERY_FILTER_OPERATOR",
                        "INVALID_QUERY_LOCATOR",
                        "INVALID_QUERY_SCOPE",
                        "INVALID_REPLICATION_DATE",
                        "INVALID_SEARCH",
                        "INVALID_SEARCH_SCOPE",
                        "INVALID_SESSION_ID",
                        "INVALID_SOAP_HEADER",
                        "INVALID_SORT_OPTION",
                        "INVALID_SSO_GATEWAY_URL",
                        "INVALID_TYPE",
                        "INVALID_TYPE_FOR_OPERATION",
                        "JIGSAW_IMPORT_LIMIT_EXCEEDED",
                        "JIGSAW_REQUEST_NOT_SUPPORTED",
                        "JSON_PARSER_ERROR",
                        "LICENSING_UNKNOWN_ERROR",
                        "LIMIT_EXCEEDED",
                        "LOGIN_CHALLENGE_ISSUED",
                        "LOGIN_CHALLENGE_PENDING",
                        "LOGIN_DURING_RESTRICTED_DOMAIN",
                        "LOGIN_DURING_RESTRICTED_TIME",
                        "LOGIN_MUST_USE_SECURITY_TOKEN",
                        "MALFORMED_ID",
                        "MALFORMED_QUERY",
                        "MALFORMED_SEARCH",
                        "MISSING_ARGUMENT",
                        "NOT_MODIFIED",
                        "NO_SOFTPHONE_LAYOUT",
                        "NUMBER_OUTSIDE_VALID_RANGE",
                        "OPERATION_TOO_LARGE",
                        "ORG_IN_MAINTENANCE",
                        "ORG_IS_DOT_ORG",
                        "ORG_LOCKED",
                        "ORG_NOT_OWNED_BY_INSTANCE",
                        "PASSWORD_LOCKOUT",
                        "PORTAL_NO_ACCESS",
                        "POST_BODY_PARSE_ERROR",
                        "QUERY_TIMEOUT",
                        "QUERY_TOO_COMPLICATED",
                        "REQUEST_LIMIT_EXCEEDED",
                        "REQUEST_RUNNING_TOO_LONG",
                        "SERVER_UNAVAILABLE",
                        "SOCIALCRM_FEEDSERVICE_API_CLIENT_EXCEPTION",
                        "SOCIALCRM_FEEDSERVICE_API_SERVER_EXCEPTION",
                        "SOCIALCRM_FEEDSERVICE_API_UNAVAILABLE",
                        "SSO_SERVICE_DOWN",
                        "TOO_MANY_APEX_REQUESTS",
                        "TOO_MANY_RECIPIENTS",
                        "TRIAL_EXPIRED",
                        "UNKNOWN_ATTACHMENT_EXCEPTION",
                        "UNKNOWN_EXCEPTION",
                        "UNSUPPORTED_API_VERSION",
                        "UNSUPPORTED_ATTACHMENT_ENCODING",
                        "UNSUPPORTED_CLIENT",
                        "UNSUPPORTED_MEDIA_TYPE",
                        "XML_PARSER_ERROR"
                };
    }
    
}
