/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.wsdl;

import com.mulesoft.utils.xml.Element;

import java.util.ArrayList;
import java.util.List;

public class Binding extends WsdlNode
{
    private PortType portType;
    List<BindingOperation> operations;
    
    public Binding(String name, PortType portType)
    {
        super(name);
        this.portType = portType;
        this.operations = new ArrayList<BindingOperation>();
    }
    
    public void addOperation(BindingOperation op)
    {
        operations.add(op);
    }

    @Override
    public Element generate()
    {
        Element elm = generate("binding").addAttr("type", "tns:" + portType.getName());
        elm.addChild(new Element("soap:binding").addAttr("style", "document").addAttr("transport", "http://schemas.xmlsoap.org/soap/http"));
        for (BindingOperation op : operations)
        {
            elm.addChild(op.generate());
        }

        return elm;
    }
}
