/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.wsdl;

import com.mulesoft.utils.xml.Element;

import java.util.ArrayList;
import java.util.List;

public class BindingOperation extends WsdlNode
{
    private List<String> inputHeaderParts;
    private List<String> outputHeaderParts;
    private List<String> faultNames;
    
    public BindingOperation(String name)
    {
        super(name);
        inputHeaderParts = new ArrayList<String>();
        outputHeaderParts = new ArrayList<String>();
        faultNames = new ArrayList<String>();
    }
    
    public void addInputHeaderPart(String partName)
    {
        inputHeaderParts.add(partName);
    }

    public void addOutputHeaderPart(String partName)
    {
        outputHeaderParts.add(partName);
    }

    public void addFaultName(String faultName)
    {
        faultNames.add(faultName);
    }

    @Override
    public Element generate()
    {
        Element elm = generate("operation");
        Element soapOp = new Element("soap", "operation");
        soapOp.addAttr("soapAction", "");
        elm.addChild(soapOp);
        Element input = new Element("input");
        elm.addChild(input);
        for (String header : inputHeaderParts)
        {
           input.addChild(new Element("soap", "header").addAttr("use", "literal").addAttr("message", "tns:HHeader").addAttr("part", header));
        }
        input.addChild(new Element("soap", "body").addAttr("parts", "parameters").addAttr("use","literal"));
        Element output = new Element("output");
        elm.addChild(output);
        for (String header : inputHeaderParts)
        {
            output.addChild(new Element("soap", "header").addAttr("use", "literal").addAttr("message", "tns:HHeader").addAttr("part", header));
        }
        output.addChild(new Element("soap", "body").addAttr("use", "literal"));
        for (String faultName: faultNames)
        {
            Element fault = new Element("fault").addAttr("name", faultName);
            fault.addChild(new Element("soap", "fault").addAttr("name", faultName).addAttr("use", "literal"));
            elm.addChild(fault);
        }

        return elm;
    }
}
