/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.wsdl;

import com.mulesoft.utils.xml.Element;

import java.util.List;

public class Message extends WsdlNode
{
    private List<String> partNames;
    
    public Message(String name)
    {
        super(name);
    }

    public void addPart(String part)
    {
        partNames.add(part);
    }

    @Override
    public Element generate()
    {
        Element elm = generate("message");
        for (String part : partNames)
        {
            elm.addChild(new Element("part").addAttr("element", "tns:" + name, name));
        }

        return elm;
    }

    public Message getRequest()
    {
        return new Message(name)
        {
            @Override
            public Element generate()
            {
                Element elm = new Element("message").addAttr("name", name + "Request");
                elm.addChild(new Element("part").addAttr("element", "tns:" + name).addAttr("name", "parameters"));
                return elm;
            }
        };
    }

    public Message getResponse()
    {
        return new Message(name)
        {
            @Override
            public Element generate()
            {
                Element elm = new Element("message").addAttr("name", name + "Response");
                elm.addChild(new Element("part").addAttr("element", "tns:" + name + "Response").addAttr("name", "parameters"));
                return elm;
            }
        };
    }

    public Message getFault()
    {
        return new Message(name)
        {
            @Override
            public Element generate()
            {
                Element elm = new Element("message").addAttr("name", name);
                elm.addChild(new Element("part").addAttr("element", "fns:" + name).addAttr("name", "fault"));
                return elm;
            }
        };
    }
}
