/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.wsdl;

import com.mulesoft.utils.xml.Element;

import java.util.ArrayList;
import java.util.List;

public class Operation extends WsdlNode
{
    private List<String> faultNames;

    public Operation(String name)
    {
        super(name);
        faultNames = new ArrayList<String>();
    }

    public void addFault(String faultName)
    {
        faultNames.add(faultName);
    }

    @Override
    public Element generate()
    {
        Element elm = generate("operation");
        elm.addChild(new Element("input").addAttr("message", "tns:" + name + "Request"));
        elm.addChild(new Element("output").addAttr("message", "tns:" + name + "Response"));
        for (String faultName : faultNames)
        {
            elm.addChild(new Element("fault").addAttr("message", "tns:" + faultName ).addAttr("name", faultName));
        }

        return elm;
    }
}
