/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.wsdl;

import com.mulesoft.utils.xml.Element;

public class Port extends WsdlNode
{
    private String name;
    private Binding binding;
    private String soapAddress;

    public Port(String name, Binding binding, String soapAddress)
    {
        super(name);
        this.binding = binding;
        this.soapAddress = soapAddress;
    }
    
    @Override
    public Element generate()
    {
        Element port = generate("port");
        port.addAttr("binding", "tns:" + binding.getName());
        Element address = new Element("soap", "address");
        address.addAttr("location", soapAddress);
        port.addChild(address);
        return port;
    }
}
