/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.wsdl;

import com.mulesoft.utils.xml.Element;

import java.util.ArrayList;
import java.util.List;

public class PortType extends WsdlNode
{
    private List<Operation> operations = new ArrayList<Operation>();
    
    public PortType(String name)
    {
        super(name);
    }
    
    public void addOperation(Operation op)
    {
        operations.add(op);
    }

    @Override
    public Element generate()
    {
        Element elm = generate("portType");
        for (Operation op : operations)
        {
            elm.addChild(op.generate());
        }

        return elm;
    }
}
