/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.wsdl;

import com.mulesoft.utils.xml.Element;

import com.mulesoft.utils.wsdl.WsdlNode;

public class Schema extends WsdlNode
{
    private String prefix;
    private String targetNs;
    private String[] imports;
    
    public Schema(String prefix, String targetNs, String ... imports)
    {
        super("schema");
        this.prefix = prefix;
        this.targetNs = targetNs;
        this.imports = imports;
    }

    @Override
    public Element generate()
    {
        Element elm = new Element(getName()).addNsDef(Wsdl.SCHEMA_NS).addNsDef(prefix, targetNs)
                        .addAttr("targetNamespace", targetNs).addAttr("elementFormDefault", "qualified");
        for (String ns : imports)
        {
            elm.addChild(new Element("import").addAttr("namespace", ns));
        }
        return elm;
    }
}
