/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.wsdl;

import com.mulesoft.utils.xml.Element;

import java.util.ArrayList;
import java.util.List;

public class Service extends WsdlNode
{
    private List<Port> ports;

    public Service(String name)
    {
        super(name);
        this.ports = new ArrayList<Port>();
    }

    public void addPort(Port port)
    {
        ports.add(port);    
    }

    @Override
    public Element generate()
    {
        Element service = generate("service");
        for (Port port : ports)
        {
            service.addChild(port.generate());
        }
        return service;
    }
}
