/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.xml;

import java.io.IOException;
import java.io.Writer;

public class Attr extends Node
{
    private String value;

    public Attr(String ns, String local, String value)
    {
        super(ns, local);
        this.value = value;
    }

    public Attr(String local, String value)
    {
        super(local);
        this.value = value;
    }

    public void output(Formatter formatter) throws IOException
    {
        putName(formatter);
        formatter.put("=");
        char quote = '"';
        if (value.indexOf(quote) >= 0)
        {
            quote = '\'';    
        }
        formatter.put(quote);
        formatter.put(value);
        formatter.put(quote);
        formatter.putSpace();
    }

    public String getValue()
    {
        return value;
    }
}
