/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Element extends Node
{
    private List<Attr> attrs = new ArrayList<Attr>();
    private List<Element> children = new ArrayList<Element>();
    private String value;
    
    public Element(String ns, String local)
    {
        super(ns, local);
    }

    public Element(String local)
    {
        super(local);
    }

    public Element(String ns, String local, Element parent)
    {
        super(ns, local);
        parent.addChild(this);
    }

    public Element(String local, Element parent)
    {
        super(local);
        parent.addChild(this);
    }
    
    public Element addChild(Element child)
    {
        children.add(child);
        return this;
    }

    public Element addChildren(List<Element> theChildren)
    {
        for (Element child : theChildren)
        {
            children.add(child);
        }
        return this;
    }

    public Element addChildren(Element ... child)
    {
        for (Element theChild : child)
        {
            children.add(theChild);
        }
        return this;
    }

    public Element addAttr(Attr attr)
    {
        attrs.add(attr);
        return this;
    }

    public Element addAttr(String local, String value)
    {
        addAttr(new Attr(local, value));
        return this;
    }

    public Element addAttr(String ns, String local, String value)
    {
        addAttr(new Attr(ns, local, value));
        return this;
    }
    
    public Element addNsDef(String ns)
    {
        addAttr(new NamespaceDefinition(ns));
        return this;
    }

    public Element addNsDef(String prefix, String ns)
    {
        addAttr(new NamespaceDefinition(prefix, ns));
        return this;
    }
    
    public void setValue(String value)
    {
        this.value = value;
    }

    public void output(Formatter formatter) throws IOException
    {
        formatter.indent();
        formatter.put('<');
        putName(formatter);
        if (!attrs.isEmpty())
        {
            formatter.putSpace();
            for (Attr attr: attrs)
            {
                attr.output(formatter);
            }
        }
        if (children.size() == 0 && value == null)
        {
            formatter.put("/>");
            formatter.putLine();
        }
        else
        {
            formatter.put(">");
            if (value != null)
            {
                formatter.put(value);                
            }
            else
            {
                formatter.putLine();
                formatter.adjustIndent(1);
                for (Element child : children)
                {
                    child.output(formatter);
                }
                formatter.adjustIndent(-1);
                formatter.indent();
            }
            formatter.put("</");
            putName(formatter);
            formatter.put(">");
            formatter.putLine();
        }
    }
    
    public String getAttrValue(String name)
    {
        for (Attr attr: attrs)
        {
            if (attr.getNs() == null && name.equals(attr.getLocal()))
            {
                return attr.getValue();
            }
        }
        
        return null;
    }

    public Iterable<Element> getChildren()
    {
        return new Iterable<Element>()
        {
            public Iterator<Element> iterator()
            {
                return children.iterator();
            }
        };
    }


}
