/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.utils.xml;

import java.io.IOException;
import java.io.Writer;

public class Formatter
{
    private int currentIndentLevel;
    final private Writer writer;
    final private int indentSize;
    
    public Formatter(Writer writer, int indentSize)
    {
        this.writer = writer;
        this.indentSize = indentSize;
        this.currentIndentLevel = 0;
    }

    public void indent() throws IOException
    {
        for (int i = 0; i < currentIndentLevel; i++)
        {
            writer.write(' ');
        }
    }

    public void put(String string) throws IOException
    {
        writer.write(string);
    }

    public void put(char c) throws IOException
    {
        writer.write(c);
    }

    public void putLine() throws IOException
    {
        writer.write(System.getProperty("line.separator"));
    }

    public void putSpace() throws IOException
    {
        put(' ');
    }
    
    public void adjustIndent(int count)
    {
        currentIndentLevel += count * indentSize;
    }

    public void flush() throws IOException
    {
        writer.flush();
    }

    public void close() throws IOException
    {
        writer.close();
    }
}
