/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.utils.xml;

import java.io.IOException;
import java.io.Writer;

abstract public class Node
{
    final protected String ns;
    final protected String local;

    protected Node(String ns, String local)
    {
        this.ns = ns;
        this.local = local;
    }

    protected Node(String local)
    {
        this.local = local;
        this.ns = null;
    }

    public String getNs()
    {
        return ns;
    }

    public String getLocal()
    {
        return local;
    }

    abstract public void output(Formatter formatter) throws IOException;

    protected void putName(Formatter formatter) throws IOException
    {
        if (ns != null)
        {
            formatter.put(ns);
            formatter.put(":");
        }
        formatter.put(local);
    }
}
