/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.af.sample.adapter.ra;

import com.sap.aii.af.sample.adapter.ra.XITrace;
import com.sap.aii.af.service.administration.api.cpa.CPAFactory;
import com.sap.aii.af.service.administration.api.cpa.CPALookupManager;
import com.sap.aii.af.service.cpa.AbstractPartyCallBackHandler;
import com.sap.aii.af.service.cpa.CPAException;
import com.sap.aii.af.service.cpa.Party;
import com.sap.aii.af.service.cpa.PartyIdentifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartyChangeCallBackHandler
extends AbstractPartyCallBackHandler {
    private static final XITrace TRACE = new XITrace(PartyChangeCallBackHandler.class.getName());
    public static final String DUNS = "DUNS";
    private static PartyChangeCallBackHandler partyChangeCallBackHandler = new PartyChangeCallBackHandler();
    private HashMap<String, String> partyidentifierMap = new HashMap();

    private PartyChangeCallBackHandler() {
    }

    public static PartyChangeCallBackHandler getInstance() {
        return partyChangeCallBackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partyrefreshEvent(Party arg0) {
        String SIGNATURE = "partyrefreshEvent(Party arg0)";
        TRACE.entering("partyrefreshEvent(Party arg0)", new Object[]{arg0});
        try {
            String partyName = arg0.getParty();
            HashMap<String, String> hashMap = this.partyidentifierMap;
            synchronized (hashMap) {
                if (this.partyidentifierMap.containsKey(partyName)) {
                    CPALookupManager lookupManager = CPAFactory.getInstance().getLookupManager();
                    LinkedList list = lookupManager.getPartyIdentifiersByParty(arg0);
                    Iterator it = list.iterator();
                    String oldId = this.partyidentifierMap.get(partyName);
                    while (it.hasNext()) {
                        PartyIdentifier partyIdentifier = (PartyIdentifier)it.next();
                        String id = partyIdentifier.getPartyIdentifier();
                        String schema = partyIdentifier.getPartySchema();
                        if (!schema.equals(DUNS) || id.equals(oldId)) continue;
                        TRACE.infoT("partyrefreshEvent(Party arg0)", "Received PartyChangeEvent for the Party " + arg0.getParty() + " The new Identifier is " + id);
                        this.partyidentifierMap.put(partyName, id);
                    }
                }
            }
        }
        catch (CPAException e) {
            TRACE.catching("partyrefreshEvent(Party arg0)", e);
        }
        TRACE.exiting("partyrefreshEvent(Party arg0)");
    }

    public void addParty(String partyName, String identifier) {
        this.partyidentifierMap.put(partyName, identifier);
    }

    public void removeParty(String partyName) {
        this.partyidentifierMap.remove(partyName);
    }

    public Set<String> getRegisteredParties() {
        return this.partyidentifierMap.keySet();
    }

    public void clear() {
        this.partyidentifierMap.clear();
    }
}

