/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.af.sample.adapter.ra;

import com.sap.aii.af.lib.mp.processor.ModuleProcessor;
import com.sap.aii.af.lib.mp.processor.ModuleProcessorFactory;
import com.sap.aii.af.lib.ra.cci.XIAdapterException;
import com.sap.aii.af.lib.util.ClassUtil;
import com.sap.aii.af.sample.adapter.ra.CCIConnectionFactory;
import com.sap.aii.af.sample.adapter.ra.CCIConnectionRequestInfo;
import com.sap.aii.af.sample.adapter.ra.SPIManagedConnection;
import com.sap.aii.af.sample.adapter.ra.XIAdapterCategories;
import com.sap.aii.af.sample.adapter.ra.XIConfiguration;
import com.sap.aii.af.sample.adapter.ra.XIMessageFactoryImpl;
import com.sap.aii.af.sample.adapter.ra.XISecurityUtilities;
import com.sap.aii.af.sample.adapter.ra.XITrace;
import com.sap.aii.af.sample.module.ConvertCRLFfromToLF0;
import com.sap.aii.af.service.administration.api.cpa.CPAFactory;
import com.sap.aii.af.service.cpa.CPAObjectType;
import com.sap.aii.af.service.cpa.Channel;
import com.sap.aii.af.service.cpa.Direction;
import com.sap.aii.af.service.idmap.MessageIDMapper;
import com.sap.aii.af.service.resource.SAPAdapterResources;
import com.sap.engine.interfaces.connector.ManagedConnectionFactoryActivation;
import com.sap.engine.interfaces.messaging.api.PublicAPIAccessFactory;
import com.sap.engine.interfaces.messaging.api.auditlog.AuditAccess;
import com.sap.guid.GUID;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class SPIManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable,
Runnable,
ManagedConnectionFactoryActivation {
    static final long serialVersionUID = -2387046407149571208L;
    private static final XITrace TRACE = new XITrace(SPIManagedConnectionFactory.class.getName());
    private AuditAccess audit = null;
    private GUID mcfLocalGuid = null;
    private Timer controlTimer = new Timer();
    private static final int TIMER_FIRST_RUN = 120000;
    private static final int TIMER_PERIOD = 60000;
    private static int fileCounter = 0;
    private static int waitTime = 5000;
    public static final String JNDI_NAME = "deployedAdapters/sample_ra/shareable/sample_ra";
    transient PrintWriter logWriter;
    private static Object synchronizer = new Object();
    private SAPAdapterResources msRes = null;
    private int threadStatus = 0;
    private static final int TH_INIT = 0;
    private static final int TH_STARTED = 1;
    private static final int TH_STOPPED = 2;
    private InitialContext ctx = null;
    private XIConfiguration xIConfiguration = null;
    private Map managedConnections = Collections.synchronizedMap(new HashMap());
    private transient MessageIDMapper messageIDMapper = null;
    private transient XIMessageFactoryImpl mf = null;
    static final String AS_ACTIVE = "active";
    static final String AS_INACTIVE = "inactive";
    private static final String AM_CPA = "CPA";
    private static final String AM_MSG = "MSG";
    private static final String ADDR_AGENCY_EAN = "009";
    private static final String ADDR_SCHEMA_GLN = "GLN";
    private String addressMode = null;
    private String adapterType = null;
    private String adapterNamespace = null;
    private int propWaitNum = 10;
    private int propWaitTime = 1000;
    static final String OUT_DIR = "c:/temp";
    static final String OUT_PREFIX = "sample_ra_output";
    static final String IN_DIR = "c:/temp";
    static final String IN_NAME = "sample_ra_input";
    private static final String PM_TEST = "test";
    private static final String PM_RENAME = "rename";
    static final String FM_NEW = "new";
    static final String FM_REPLACE = "replace";
    private static final String QOS_EO = "EO";
    private static final String QOS_EOIO = "EOIO";
    private static final String QOS_BE = "BE";
    private static final String ERR_NONE = "none";
    private static final String ERR_ROLLBACK = "rollback";
    static final String ASMA_NAME = "JCAChannelID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIManagedConnectionFactory() throws ResourceException {
        String SIGNATURE = "SpiManagedConnectionFactory()";
        TRACE.entering("SpiManagedConnectionFactory()");
        try {
            this.ctx = new InitialContext();
            Object res = this.ctx.lookup("SAPAdapterResources");
            this.msRes = (SAPAdapterResources)res;
        }
        catch (Exception e) {
            TRACE.catching("SpiManagedConnectionFactory()", e);
            TRACE.errorT("SpiManagedConnectionFactory()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0011", "Access to XI AF MS resource failed. Adapter cannot be started.");
        }
        try {
            Object e = synchronizer;
            synchronized (e) {
                this.mcfLocalGuid = new GUID();
                TRACE.infoT("SpiManagedConnectionFactory()", XIAdapterCategories.CONNECT_AF, "This SPIManagedConnectionFactory has the GUID: " + this.mcfLocalGuid.toString());
            }
        }
        catch (Exception e) {
            TRACE.catching("SpiManagedConnectionFactory()", e);
            TRACE.debugT("SpiManagedConnectionFactory()", XIAdapterCategories.CONNECT_AF, "Creation of MCF GUID failed. Thus no periodic status report possible! Reason: " + e.getMessage());
        }
        TRACE.exiting("SpiManagedConnectionFactory()");
    }

    private void traceSample(String someText) {
        String SIGNATURE = "traceSample()";
        TRACE.entering("traceSample()");
        TRACE.entering("traceSample()", new Object[]{someText});
        try {
            XIAdapterException te = new XIAdapterException("Test exception only");
            TRACE.throwing("traceSample()", (Throwable)te);
            throw te;
        }
        catch (Exception e) {
            TRACE.catching("traceSample()", e);
            TRACE.debugT("traceSample()", "A test TraceException was catched and ignored!");
            TRACE.exiting("traceSample()");
            TRACE.exiting("traceSample()", "some return value");
            return;
        }
    }

    private ModuleProcessor lookUpModuleProcessor(int retryNum) throws ResourceException {
        String SIGNATURE = "lookUpModuleProcessor()";
        TRACE.entering("lookUpModuleProcessor()");
        ModuleProcessor mp = null;
        try {
            mp = ModuleProcessorFactory.getModuleProcessor((boolean)true, (int)retryNum, (int)this.propWaitTime);
        }
        catch (Exception e) {
            TRACE.catching("lookUpModuleProcessor()", e);
            TRACE.errorT("lookUpModuleProcessor()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0012", "Cannot get access to the XI AF module processor. Ejb might not have been started yet.");
            ResourceException re = new ResourceException("Cannot get access to the XI AF module processor. Ejb might not have been started yet.");
            throw re;
        }
        TRACE.debugT("lookUpModuleProcessor()", XIAdapterCategories.CONNECT_AF, "Lookup of XI AF MP entry ejb was succesfully.");
        TRACE.exiting("lookUpModuleProcessor()");
        return mp;
    }

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        String SIGNATURE = "createConnectionFactory(ConnectionManager cxManager)";
        TRACE.entering("createConnectionFactory(ConnectionManager cxManager)", new Object[]{cm});
        CCIConnectionFactory factory = new CCIConnectionFactory(this, cm);
        TRACE.exiting("createConnectionFactory(ConnectionManager cxManager)");
        return factory;
    }

    public Object createConnectionFactory() throws ResourceException {
        String SIGNATURE = "createConnectionFactory()";
        TRACE.entering("createConnectionFactory()");
        CCIConnectionFactory factory = new CCIConnectionFactory(this, null);
        TRACE.exiting("createConnectionFactory()");
        return factory;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        String SIGNATURE = "createManagedConnection(Subject subject, ConnectionRequestInfo info)";
        TRACE.entering("createManagedConnection(Subject subject, ConnectionRequestInfo info)", new Object[]{subject, info});
        String channelID = null;
        Channel channel = null;
        SPIManagedConnection mc = null;
        if (!(info instanceof CCIConnectionRequestInfo)) {
            TRACE.errorT("createManagedConnection(Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0013", "Received an unknown ConnectionRequestInfo. Cannot determine channelId!");
            ResourceException re = new ResourceException("Received an unknown ConnectionRequestInfo. Cannot determine channelId!");
            TRACE.throwing("createManagedConnection(Subject subject, ConnectionRequestInfo info)", re);
            throw re;
        }
        try {
            channelID = ((CCIConnectionRequestInfo)info).getChannelId();
            channel = (Channel)CPAFactory.getInstance().getLookupManager().getCPAObject(CPAObjectType.CHANNEL, channelID);
        }
        catch (Exception e) {
            TRACE.catching("createManagedConnection(Subject subject, ConnectionRequestInfo info)", e);
            TRACE.errorT("createManagedConnection(Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0014", "Cannot access the channel parameters of channel: " + channelID + ". Check whether the channel is stopped in the administrator console.");
            ResourceException re = new ResourceException("Cannot access the channel parameters of channel: " + channelID + ". Check whether the channel is stopped in the administrator console.");
            throw re;
        }
        PasswordCredential credential = XISecurityUtilities.getPasswordCredential(this, subject, info);
        mc = new SPIManagedConnection(this, credential, false, channelID, channel);
        if (mc != null) {
            this.managedConnections.put(channelID, mc);
            TRACE.debugT("createManagedConnection(Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT_AF, "For channelID {0} this managed connection is stored: {1}", new Object[]{channelID, mc});
        }
        TRACE.exiting("createManagedConnection(Subject subject, ConnectionRequestInfo info)");
        return mc;
    }

    void destroyManagedConnection(String channelID) throws ResourceException {
        String SIGNATURE = "destroyManagedConnection(String channelID)";
        TRACE.entering("destroyManagedConnection(String channelID)", new Object[]{channelID});
        SPIManagedConnection mc = null;
        try {
            mc = (SPIManagedConnection)this.managedConnections.get(channelID);
            if (mc != null) {
                mc.sendEvent(1, null, mc);
                this.managedConnections.remove(channelID);
                mc.destroy(true);
                TRACE.debugT("destroyManagedConnection(String channelID)", XIAdapterCategories.CONNECT_AF, "ManagedConnection for channel ID {0} found and destroyed.", new Object[]{channelID});
            } else {
                TRACE.warningT("destroyManagedConnection(String channelID)", XIAdapterCategories.CONNECT_AF, "ManagedConnection for channel ID {0} not found.", new Object[]{channelID});
            }
        }
        catch (Exception e) {
            TRACE.catching("destroyManagedConnection(String channelID)", e);
            TRACE.errorT("destroyManagedConnection(String channelID)", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0015", "Received exception during ManagedConnection destroy: " + e.getMessage());
        }
        TRACE.exiting("destroyManagedConnection(String channelID)");
    }

    void removeManagedConnection(String channelID) {
        String SIGNATURE = "removeManagedConnection(String channelID)";
        TRACE.entering("removeManagedConnection(String channelID)", new Object[]{channelID});
        this.managedConnections.remove(channelID);
        TRACE.exiting("removeManagedConnection(String channelID)");
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        String SIGNATURE = "matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)";
        TRACE.entering("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", new Object[]{connectionSet, subject, info});
        SPIManagedConnection mcFound = null;
        CCIConnectionRequestInfo cciInfo = null;
        PasswordCredential pc = XISecurityUtilities.getPasswordCredential(this, subject, info);
        if (!(info instanceof CCIConnectionRequestInfo)) {
            TRACE.errorT("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT_AF, "Unknown ConnectionRequestInfo parameter received. Cannot match connection");
            return null;
        }
        cciInfo = (CCIConnectionRequestInfo)info;
        Iterator it = connectionSet.iterator();
        while (it.hasNext() && mcFound == null) {
            Object obj = it.next();
            if (obj instanceof SPIManagedConnection) {
                SPIManagedConnection mc = (SPIManagedConnection)obj;
                if (!mc.isDestroyed()) {
                    ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
                    if (XISecurityUtilities.isPasswordCredentialEqual(mc.getPasswordCredential(), pc) && mcf.equals(this) && mc.getChannelID().equalsIgnoreCase(cciInfo.getChannelId())) {
                        mcFound = mc;
                        TRACE.debugT("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT, "Found existing ManagedConnection in container set for channel {0}.", new Object[]{mc.getChannelID()});
                        continue;
                    }
                    TRACE.debugT("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT, "ManagedConnection in container set does not fit. Ignore.");
                    continue;
                }
                TRACE.debugT("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT, "Destroyed sample ManagedConnection in container set. Ignore.");
                continue;
            }
            TRACE.debugT("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)", XIAdapterCategories.CONNECT, "This is not a sample ManagedConnection in container set. Ignore.");
        }
        TRACE.exiting("matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)");
        return mcFound;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        String SIGNATURE = "setLogWriter(PrintWriter out)";
        TRACE.entering("setLogWriter(PrintWriter out)", new Object[]{out});
        out.print("XI AF Sample Adapter has received a J2EE container log writer.");
        out.print("XI AF Sample Adapter will not use the J2EE container log writer. See the trace file for details.");
        this.logWriter = out;
        TRACE.exiting("setLogWriter(PrintWriter out)");
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    AuditAccess getAuditAccess() {
        return this.audit;
    }

    XIMessageFactoryImpl getXIMessageFactoryImpl() {
        return this.mf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutFileName(String outFileNamePrefix) {
        String SIGNATURE = "getFileName()";
        TRACE.entering("getFileName()");
        int cnt = 0;
        String fileName = null;
        Object object = synchronizer;
        synchronized (object) {
            cnt = fileCounter++;
        }
        fileName = new String(outFileNamePrefix + "." + Integer.toString(cnt) + ".txt");
        TRACE.debugT("getFileName()", XIAdapterCategories.CONNECT, "Output file name =" + fileName);
        TRACE.exiting("getFileName()");
        return fileName;
    }

    public boolean equals(Object obj) {
        SPIManagedConnectionFactory other;
        String SIGNATURE = "equals(Object obj)";
        TRACE.entering("equals(Object obj)", new Object[]{obj});
        boolean equal = false;
        if (obj instanceof SPIManagedConnectionFactory && this.adapterNamespace.equals((other = (SPIManagedConnectionFactory)obj).getAdapterNamespace()) && this.adapterType.equals(other.getAdapterType()) && this.addressMode.equals(other.getAddressMode())) {
            equal = true;
        }
        TRACE.exiting("equals(Object obj)");
        return equal;
    }

    public int hashCode() {
        String SIGNATURE = "hashCode()";
        TRACE.entering("hashCode()");
        int hash = 0;
        String propset = this.adapterNamespace + this.adapterType + this.addressMode;
        hash = propset.hashCode();
        TRACE.exiting("hashCode()");
        return hash;
    }

    public static int getFileCounter() {
        return fileCounter;
    }

    public String getAddressMode() {
        String SIGNATURE = "getAddressMode()";
        TRACE.entering("getAddressMode()");
        TRACE.debugT("getAddressMode()", XIAdapterCategories.CONNECT, "Address determination mode =" + this.addressMode);
        TRACE.exiting("getAddressMode()");
        return this.addressMode;
    }

    public void setAddressMode(String addressMode) {
        this.addressMode = addressMode;
    }

    public void startMCF() throws ResourceException {
        String SIGNATURE = "startMCF()";
        TRACE.entering("startMCF()");
        if (this.threadStatus != 1) {
            try {
                this.threadStatus = 1;
                this.msRes.startRunnable((Runnable)this);
            }
            catch (Exception e) {
                TRACE.catching("startMCF()", e);
                this.threadStatus = 2;
                TRACE.errorT("startMCF()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0016", "Cannot start inbound message thread");
                ResourceException re = new ResourceException(e.getMessage());
                TRACE.throwing("startMCF()", re);
                throw re;
            }
        }
        TRACE.exiting("startMCF()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMCF() throws ResourceException {
        String SIGNATURE = "stopMCF()";
        TRACE.entering("stopMCF()");
        this.threadStatus = 2;
        try {
            SPIManagedConnectionFactory sPIManagedConnectionFactory = this;
            synchronized (sPIManagedConnectionFactory) {
                this.notify();
                this.wait(waitTime + 1000);
            }
            this.xIConfiguration.stop();
        }
        catch (Exception e) {
            TRACE.catching("stopMCF()", e);
            TRACE.errorT("stopMCF()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0017", "Cannot stop inbound message thread. Reason: " + e.getMessage());
            ResourceException re = new ResourceException(e.getMessage());
            TRACE.throwing("stopMCF()", re);
            throw re;
        }
        TRACE.exiting("stopMCF()");
    }

    public void startTimer() {
        String SIGNATURE = "startTimer()";
        TRACE.entering("startTimer()");
        if (this.mcfLocalGuid != null) {
            try {
                this.controlTimer.scheduleAtFixedRate((TimerTask)new XIManagedConnectionFactoryController(this, this.ctx), 120000L, 60000L);
            }
            catch (Exception e) {
                TRACE.catching("startTimer()", e);
                TRACE.debugT("startTimer()", XIAdapterCategories.CONNECT_AF, "Creation of MCF controller failed. No periodic MCF status reports available! Reason: " + e.getMessage());
            }
        }
        TRACE.exiting("startTimer()");
    }

    public void stopTimer() {
        String SIGNATURE = "stopTimer()";
        TRACE.entering("stopTimer()");
        this.controlTimer.cancel();
        TRACE.exiting("stopTimer()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String SIGNATURE = "run()";
        TRACE.entering("run()");
        String oldThreadName = Thread.currentThread().getName();
        String newThreadName = "XI AF Sample Adapter MCF " + this.mcfLocalGuid;
        try {
            Thread.currentThread().setName(newThreadName);
            TRACE.debugT("run()", XIAdapterCategories.CONNECT_AF, "Switched thread name to: {0}", new Object[]{newThreadName});
            boolean notSet = true;
            int numTry = 0;
            int pollTime = -1;
            while (notSet && numTry < this.propWaitNum) {
                if (this.addressMode != null && this.adapterType != null && this.adapterNamespace != null) {
                    notSet = false;
                }
                TRACE.debugT("run()", XIAdapterCategories.CONNECT_AF, "MCF waits for setter completion. Try: {0} of {1}.", new Object[]{Integer.toString(++numTry), Integer.toString(this.propWaitNum)});
                try {
                    Thread.sleep(this.propWaitTime);
                }
                catch (Exception e) {
                    TRACE.catching("run()", e);
                }
            }
            if (this.addressMode == null) {
                this.addressMode = AM_CPA;
            }
            if (this.adapterType == null) {
                this.adapterType = "JCA";
            }
            if (this.adapterNamespace == null) {
                this.adapterNamespace = "http://sap.com/xi/XI/sample";
            }
            ModuleProcessor mp = null;
            try {
                mp = this.lookUpModuleProcessor(this.propWaitNum);
            }
            catch (Exception e) {
                TRACE.catching("run()", e);
                TRACE.errorT("run()", XIAdapterCategories.CONNECT_AF, "Cannot instatiate the XI AF module processor bean. The inbound processing is stopped. Exception:" + e.toString());
                this.threadStatus = 2;
            }
            if (this.xIConfiguration == null) {
                try {
                    this.xIConfiguration = new XIConfiguration(this.adapterType, this.adapterNamespace);
                    this.xIConfiguration.init(this);
                }
                catch (Exception e) {
                    TRACE.catching("run()", e);
                    TRACE.errorT("run()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0018", "Cannot instatiate the XI CPA handler. The inbound processing is stopped. Exception:" + e.toString());
                    this.threadStatus = 2;
                }
            }
            while (this.threadStatus == 1) {
                try {
                    LinkedList channels = this.xIConfiguration.getCopy(Direction.INBOUND);
                    for (int i = 0; i < channels.size(); ++i) {
                        Channel channel = (Channel)channels.get(i);
                        try {
                            String directory = null;
                            String name = null;
                            String processMode = null;
                            String qos = null;
                            String psec = null;
                            String pmsec = null;
                            String raiseError = null;
                            String channelAddressMode = null;
                            boolean set_asma = false;
                            try {
                                directory = channel.getValueAsString("fileInDir");
                            }
                            catch (Exception e) {
                                TRACE.catching("run()", e);
                            }
                            try {
                                name = channel.getValueAsString("fileInName");
                            }
                            catch (Exception e) {
                                TRACE.catching("run()", e);
                            }
                            try {
                                processMode = channel.getValueAsString("processMode");
                            }
                            catch (Exception e) {
                                TRACE.catching("run()", e);
                            }
                            try {
                                qos = channel.getValueAsString("qos");
                            }
                            catch (Exception e) {
                                TRACE.catching("run()", e);
                            }
                            try {
                                psec = channel.getValueAsString("filePollInterval");
                            }
                            catch (Exception e) {
                                TRACE.catching("run()", e);
                            }
                            try {
                                pmsec = channel.getValueAsString("filePollIntervalMsecs");
                            }
                            catch (Exception e) {
                                TRACE.catching("run()", e);
                            }
                            try {
                                raiseError = channel.getValueAsString("raiseError");
                            }
                            catch (Exception e) {
                                TRACE.catching("run()", e);
                            }
                            try {
                                channelAddressMode = channel.getValueAsString("channelAddressMode");
                            }
                            catch (Exception e) {
                                TRACE.catching("run()", e);
                            }
                            try {
                                set_asma = channel.getValueAsBoolean("enableDynConfigSender");
                                if (set_asma) {
                                    set_asma = channel.getValueAsBoolean("dynConfigJCAChannelID");
                                }
                            }
                            catch (Exception e) {
                                TRACE.catching("run()", e);
                            }
                            int ptime = 0;
                            if (psec != null && psec.length() > 0) {
                                ptime = Integer.valueOf(psec) * 1000;
                            }
                            if (pmsec != null && pmsec.length() > 0) {
                                ptime += Integer.valueOf(pmsec).intValue();
                            }
                            if (pollTime < 0 || ptime < pollTime) {
                                pollTime = ptime;
                            }
                            if (directory == null || directory.length() == 0) {
                                TRACE.warningT("run()", XIAdapterCategories.CONNECT_AF, "Unable to determine input file directory. Take default: c:/temp");
                                directory = "c:/temp";
                            }
                            if (name == null || name.length() == 0) {
                                TRACE.warningT("run()", XIAdapterCategories.CONNECT_AF, "Unable to determine input file prefix. Take default: sample_ra_input");
                                name = IN_NAME;
                            }
                            if (processMode == null || processMode.length() == 0) {
                                TRACE.warningT("run()", XIAdapterCategories.CONNECT_AF, "Unable to determine processing mode. Take default: test");
                                processMode = PM_TEST;
                            }
                            if (qos == null || qos.length() == 0) {
                                TRACE.warningT("run()", XIAdapterCategories.CONNECT_AF, "Unable to determine QOS. Take default: EO");
                                qos = QOS_EO;
                            }
                            if (raiseError == null || raiseError.length() == 0) {
                                TRACE.warningT("run()", XIAdapterCategories.CONNECT_AF, "Unable to determine error raise condition. Take default: none");
                                raiseError = ERR_NONE;
                            }
                            if (channelAddressMode == null || channelAddressMode.length() == 0) {
                                TRACE.warningT("run()", XIAdapterCategories.CONNECT_AF, "Unable to determine address mode. Take default from JCA property: " + this.addressMode);
                                channelAddressMode = this.addressMode;
                            }
                            String completeName = directory + "/" + name;
                            this.sendMessageFromFile(completeName, channel, processMode, qos, raiseError, channelAddressMode, set_asma);
                            continue;
                        }
                        catch (Exception e) {
                            TRACE.catching("run()", e);
                            TRACE.errorT("run()", XIAdapterCategories.CONNECT_AF, "Cannot send message to channel {0}. Received exception: {1}", new Object[]{channel.getObjectId(), e.getMessage()});
                        }
                    }
                }
                catch (Exception e) {
                    TRACE.catching("run()", e);
                    TRACE.errorT("run()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0019", "Cannot access inbound channel configuration. Received exception: " + e.getMessage());
                }
                try {
                    SPIManagedConnectionFactory e = this;
                    synchronized (e) {
                        if (pollTime <= 0) {
                            this.wait(waitTime);
                        } else {
                            this.wait(pollTime);
                        }
                    }
                }
                catch (InterruptedException e1) {
                    TRACE.catching("run()", e1);
                    TRACE.errorT("run()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0020", "Inbound thread stopped. Received exception during wait period: " + e1.getMessage());
                    this.threadStatus = 2;
                }
            }
            Thread.currentThread().setName(oldThreadName);
        }
        catch (Throwable throwable) {
            Thread.currentThread().setName(oldThreadName);
            TRACE.debugT("run()", XIAdapterCategories.CONNECT_AF, "Switched thread name back to: {0}", new Object[]{oldThreadName});
            throw throwable;
        }
        TRACE.debugT("run()", XIAdapterCategories.CONNECT_AF, "Switched thread name back to: {0}", new Object[]{oldThreadName});
    }

    /*
     * Exception decompiling
     */
    private void sendMessageFromFile(String inFileName, Channel channel, String processMode, String qos, String raiseError, String channelAddressMode, boolean set_asma) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void renameFile(String inFileName, File inputFile) throws Exception {
        String SIGNATURE = "renameFile(String inFileName, File inputFile)";
        try {
            File renamed = new File(inFileName + ".sent");
            renamed.delete();
            if (!inputFile.renameTo(renamed)) {
                TRACE.errorT("renameFile(String inFileName, File inputFile)", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0033", "Input file " + inFileName + " cannot be renamed. It will be sent again!");
            }
        }
        catch (Exception e) {
            TRACE.catching("renameFile(String inFileName, File inputFile)", e);
            TRACE.errorT("renameFile(String inFileName, File inputFile)", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0034", "Input file " + inFileName + " cannot be renamed. Received exception: " + e.getMessage());
            throw e;
        }
    }

    private String findValue(String key, String text) {
        String SIGNATURE = "findValue(String key, String text)";
        int startIndex = text.indexOf(key);
        if (startIndex < 0) {
            return new String("");
        }
        int endIndex = text.indexOf(";", startIndex += key.length());
        if (endIndex < 0) {
            endIndex = text.lastIndexOf(text);
        }
        String value = text.substring(startIndex, endIndex);
        TRACE.debugT("findValue(String key, String text)", XIAdapterCategories.CONNECT_AF, "findValue data (key,value,start,end): " + key + "," + value + "," + Integer.toString(startIndex) + "," + Integer.toString(endIndex));
        return value;
    }

    public String getAdapterNamespace() {
        String SIGNATURE = "getAdapterNamespace()";
        TRACE.entering("getAdapterNamespace()");
        TRACE.exiting("getAdapterNamespace()");
        return this.adapterNamespace;
    }

    public String getAdapterType() {
        return this.adapterType;
    }

    public void setAdapterNamespace(String adapterNamespace) {
        String SIGNATURE = "setAdapterNamespace(String adapterNamespace)";
        TRACE.entering("setAdapterNamespace(String adapterNamespace)", new Object[]{adapterNamespace});
        this.adapterNamespace = adapterNamespace;
        TRACE.exiting("setAdapterNamespace(String adapterNamespace)");
    }

    public void setAdapterType(String adapterType) {
        String SIGNATURE = "setAdapterType(String adapterType)";
        TRACE.entering("setAdapterType(String adapterType)", new Object[]{adapterType});
        this.adapterType = adapterType;
        TRACE.exiting("setAdapterType(String adapterType)");
    }

    public GUID getMcfLocalGuid() {
        return this.mcfLocalGuid;
    }

    public void start() {
        String SIGNATURE = "start()";
        TRACE.entering("start()");
        String controlledMcfGuid = this.getMcfLocalGuid().toHexString();
        TRACE.infoT("start()", XIAdapterCategories.CONNECT_AF, "MCF with GUID {0} is started now. ({1})", new Object[]{controlledMcfGuid.toString(), SPIManagedConnectionFactory.class.getClassLoader()});
        try {
            this.audit = PublicAPIAccessFactory.getPublicAPIAccess().getAuditAccess();
        }
        catch (Exception e) {
            TRACE.catching("start()", e);
            TRACE.errorT("start()", XIAdapterCategories.CONNECT, "SOA.apt_sample.0035", "Unable to access the XI AF audit log. Reason: {0}. Adapter cannot not start the inbound processing!", e);
            TRACE.exiting("start()");
            return;
        }
        this.messageIDMapper = MessageIDMapper.getInstance();
        if (this.messageIDMapper == null) {
            TRACE.errorT("start()", XIAdapterCategories.CONNECT, "SOA.apt_sample.0036", "Gut null as MessageIDMapper singleton instance. Adapter cannot not start the inbound processing!");
            TRACE.exiting("start()");
            return;
        }
        try {
            this.mf = new XIMessageFactoryImpl(this.adapterType, this.adapterNamespace);
        }
        catch (Exception e) {
            TRACE.catching("start()", e);
            TRACE.errorT("start()", XIAdapterCategories.CONNECT, "SOA.apt_sample.0037", "Unable to create XI message factory. Adapter cannot not start the inbound processing!");
            TRACE.exiting("start()");
            return;
        }
        try {
            this.startMCF();
            this.startTimer();
            TRACE.infoT("start()", XIAdapterCategories.CONNECT_AF, "MCF with GUID {0} was started successfully.", new Object[]{controlledMcfGuid.toString()});
        }
        catch (Exception e) {
            TRACE.catching("start()", e);
            TRACE.errorT("start()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0038", "Start of MCF failed. Reason: {0}", e.getMessage());
        }
        try {
            ClassUtil.setClassLoader((String)"com.sap.aii.af.sample.module.ConvertCRLFfromToLF0", (ClassLoader)ConvertCRLFfromToLF0.class.getClassLoader());
        }
        catch (Exception e) {
            TRACE.catching("start()", e);
            TRACE.errorT("start()", XIAdapterCategories.CONNECT_AF, "SOA.apt_sample.0039", "Unable to register pojo modules. Reason: {0}", e.getMessage());
        }
        TRACE.exiting("start()");
    }

    public void stop() {
        String SIGNATURE = "stop()";
        TRACE.entering("stop()");
        String controlledMcfGuid = this.getMcfLocalGuid().toHexString();
        TRACE.infoT("stop()", XIAdapterCategories.CONNECT_AF, "The running MCF with GUID {0} will be stopped now", new Object[]{controlledMcfGuid.toString()});
        ClassUtil.removeClassLoader((String)"com.sap.aii.af.sample.module.ConvertCRLFfromToLF0");
        try {
            this.stopMCF();
            this.stopTimer();
        }
        catch (Exception e) {
            TRACE.catching("stop()", e);
        }
        TRACE.infoT("stop()", XIAdapterCategories.CONNECT_AF, "MCF with GUID {0} was stopped successfully.", new Object[]{controlledMcfGuid.toString()});
        TRACE.exiting("stop()");
    }

    public boolean isRunning() {
        return this.threadStatus == 1;
    }

    class XIManagedConnectionFactoryController
    extends TimerTask {
        private SPIManagedConnectionFactory controlledMcf;

        public XIManagedConnectionFactoryController(SPIManagedConnectionFactory mcf, InitialContext ctx) {
            this.controlledMcf = mcf;
        }

        public void run() {
            String SIGNATURE = "XIManagedConnectionFactoryController.run()";
            String controlledMcfGuid = null;
            try {
                if (this.controlledMcf != null) {
                    controlledMcfGuid = this.controlledMcf.getMcfLocalGuid().toHexString();
                }
                TRACE.debugT("XIManagedConnectionFactoryController.run()", XIAdapterCategories.CONNECT_AF, "MCF with GUID {0} is running. ({1})", new Object[]{controlledMcfGuid.toString(), SPIManagedConnectionFactory.class.getClassLoader()});
            }
            catch (Exception e) {
                TRACE.catching("XIManagedConnectionFactoryController.run()", e);
                TRACE.warningT("XIManagedConnectionFactoryController.run()", XIAdapterCategories.CONNECT_AF, "Processing of control timer failed. Reason: " + e.getMessage());
            }
        }
    }
}

