/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.af.sample.adapter.ra;

import com.sap.aii.af.sample.adapter.ra.XITrace;
import java.util.Vector;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;

public class XIConnectionEventListenerManager {
    private static final XITrace TRACE = new XITrace(XIConnectionEventListenerManager.class.getName());
    private Vector listeners;
    private ManagedConnection mc = null;

    public XIConnectionEventListenerManager(ManagedConnection mc) {
        String SIGNATURE = "CciConnectionEventListenerManager(ManagedConnection mc)";
        TRACE.entering("CciConnectionEventListenerManager(ManagedConnection mc)", new Object[]{mc});
        this.listeners = new Vector();
        this.mc = mc;
        TRACE.exiting("CciConnectionEventListenerManager(ManagedConnection mc)");
    }

    public void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        String SIGNATURE = "sendEvent(int eventType, Exception ex, Object connectionHandle)";
        TRACE.entering("sendEvent(int eventType, Exception ex, Object connectionHandle)", new Object[]{new Integer(eventType), ex, connectionHandle});
        Vector list = (Vector)this.listeners.clone();
        ConnectionEvent ce = null;
        ce = ex == null ? new ConnectionEvent(this.mc, eventType) : new ConnectionEvent(this.mc, eventType, ex);
        if (connectionHandle != null) {
            ce.setConnectionHandle(connectionHandle);
        }
        int size = list.size();
        block7: for (int i = 0; i < size; ++i) {
            ConnectionEventListener l = (ConnectionEventListener)list.elementAt(i);
            switch (eventType) {
                case 1: {
                    l.connectionClosed(ce);
                    continue block7;
                }
                case 2: {
                    l.localTransactionStarted(ce);
                    continue block7;
                }
                case 3: {
                    l.localTransactionCommitted(ce);
                    continue block7;
                }
                case 4: {
                    l.localTransactionRolledback(ce);
                    continue block7;
                }
                case 5: {
                    l.connectionErrorOccurred(ce);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Illegal eventType: " + eventType);
                }
            }
        }
        TRACE.exiting("sendEvent(int eventType, Exception ex, Object connectionHandle)");
    }

    public void addConnectorListener(ConnectionEventListener listener) {
        String SIGNATURE = "addConnectorListener(ConnectionEventListener listener)";
        TRACE.entering("addConnectorListener(ConnectionEventListener listener)", new Object[]{listener});
        if (listener != null) {
            this.listeners.addElement(listener);
        }
        TRACE.exiting("addConnectorListener(ConnectionEventListener listener)");
    }

    public void removeConnectorListener(ConnectionEventListener listener) {
        String SIGNATURE = "removeConnectorListener(ConnectionEventListener listener)";
        TRACE.entering("removeConnectorListener(ConnectionEventListener listener)", new Object[]{listener});
        if (listener != null) {
            this.listeners.removeElement(listener);
        }
        TRACE.exiting("removeConnectorListener(ConnectionEventListener listener)");
    }
}

