/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.af.sample.adapter.ra;

import com.sap.aii.af.lib.ra.cci.XIMessageRecord;
import com.sap.aii.af.lib.ra.cci.XIRecordFactory;
import com.sap.aii.af.sample.adapter.ra.XIMessageRecordImpl;
import com.sap.aii.af.sample.adapter.ra.XITrace;
import com.sap.engine.interfaces.messaging.api.AckType;
import com.sap.engine.interfaces.messaging.api.Action;
import com.sap.engine.interfaces.messaging.api.Message;
import com.sap.engine.interfaces.messaging.api.MessageFactory;
import com.sap.engine.interfaces.messaging.api.MessageKey;
import com.sap.engine.interfaces.messaging.api.Party;
import com.sap.engine.interfaces.messaging.api.PublicAPIAccessFactory;
import com.sap.engine.interfaces.messaging.api.Service;
import com.sap.engine.interfaces.messaging.api.ack.AckFactory;
import com.sap.engine.interfaces.messaging.api.exception.MessagingException;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.MappedRecord;

public class XIMessageFactoryImpl
implements XIRecordFactory {
    private static final String AF_MSGFCT_TYPE = "XI";
    private static final XITrace TRACE = new XITrace(XIMessageFactoryImpl.class.getName());
    private MessageFactory mf = null;
    private AckFactory af = null;
    private String ackfct = null;

    public XIMessageFactoryImpl(String adapterType, String adapterNamespace) throws ResourceException {
        String SIGNATURE = "XIMessageFactoryImpl(String adapterType, String adapterNamespace)";
        TRACE.entering("XIMessageFactoryImpl(String adapterType, String adapterNamespace)", new Object[]{adapterType, adapterNamespace});
        try {
            this.mf = PublicAPIAccessFactory.getPublicAPIAccess().createMessageFactory(AF_MSGFCT_TYPE);
            this.af = PublicAPIAccessFactory.getPublicAPIAccess().createAckFactory();
            this.ackfct = adapterType + "_" + adapterNamespace;
        }
        catch (Exception e) {
            TRACE.catching("XIMessageFactoryImpl(String adapterType, String adapterNamespace)", e);
            ResourceException re = new ResourceException(e.getMessage());
            TRACE.throwing("XIMessageFactoryImpl(String adapterType, String adapterNamespace)", re);
            throw re;
        }
        TRACE.exiting("XIMessageFactoryImpl(String adapterType, String adapterNamespace)");
    }

    public Message createMessageRecord(String fromParty, String toParty, String fromService, String toService, String action, String actionNS) throws ResourceException {
        String SIGNATURE = "createMessageRecord(String fromParty, String toParty, String fromService, String toService, String action)";
        TRACE.entering("createMessageRecord(String fromParty, String toParty, String fromService, String toService, String action)", new Object[]{fromParty, toParty, fromService, toService, action});
        Message msg = null;
        try {
            Party fp = new Party(fromParty);
            Party tp = new Party(toParty);
            Service fs = new Service(fromService);
            Service ts = new Service(toService);
            Action a = new Action(action, actionNS);
            msg = this.mf.createMessage(fp, tp, fs, ts, a);
        }
        catch (Exception e) {
            TRACE.catching("createMessageRecord(String fromParty, String toParty, String fromService, String toService, String action)", e);
            ResourceException re = new ResourceException(e.getMessage());
            TRACE.throwing("createMessageRecord(String fromParty, String toParty, String fromService, String toService, String action)", re);
            throw re;
        }
        return msg;
    }

    public Message createMessageRecord(Party fromParty, Party toParty, Service fromService, Service toService, Action action) throws ResourceException {
        String SIGNATURE = "createMessageRecord(Party fromParty, Party toParty, Service fromService, Service toService, Action action)";
        TRACE.entering("createMessageRecord(Party fromParty, Party toParty, Service fromService, Service toService, Action action)", new Object[]{fromParty, toParty, fromService, toService, action});
        Message msg = null;
        try {
            msg = this.mf.createMessage(fromParty, toParty, fromService, toService, action);
        }
        catch (Exception e) {
            TRACE.catching("createMessageRecord(Party fromParty, Party toParty, Service fromService, Service toService, Action action)", e);
            ResourceException re = new ResourceException(e.getMessage());
            TRACE.throwing("createMessageRecord(Party fromParty, Party toParty, Service fromService, Service toService, Action action)", re);
            throw re;
        }
        return msg;
    }

    public Message createMessageRecord(String fromParty, String toParty, String fromService, String toService, String action, String actionNS, String messageId) throws ResourceException {
        String SIGNATURE = "createMessageRecord(String fromParty, String toParty, String fromService, String toService, String action, String messageId)";
        TRACE.entering("createMessageRecord(String fromParty, String toParty, String fromService, String toService, String action, String messageId)", new Object[]{fromParty, toParty, fromService, toService, action, messageId});
        Message msg = null;
        try {
            Party fp = new Party(fromParty);
            Party tp = new Party(toParty);
            Service fs = new Service(fromService);
            Service ts = new Service(toService);
            Action a = new Action(action, actionNS);
            msg = this.mf.createMessage(fp, tp, fs, ts, a, messageId);
        }
        catch (Exception e) {
            TRACE.catching("createMessageRecord(String fromParty, String toParty, String fromService, String toService, String action, String messageId)", e);
            ResourceException re = new ResourceException(e.getMessage());
            TRACE.throwing("createMessageRecord(String fromParty, String toParty, String fromService, String toService, String action, String messageId)", re);
            throw re;
        }
        return msg;
    }

    public Message createMessageRecord(Party fromParty, Party toParty, Service fromService, Service toService, Action action, String messageId) throws ResourceException {
        String SIGNATURE = "createMessageRecord(Party fromParty, Party toParty, Service fromService, Service toService, Action action, String messageId)";
        TRACE.entering("createMessageRecord(Party fromParty, Party toParty, Service fromService, Service toService, Action action, String messageId)", new Object[]{fromParty, toParty, fromService, toService, action, messageId});
        Message msg = null;
        try {
            msg = this.mf.createMessage(fromParty, toParty, fromService, toService, action, messageId);
        }
        catch (Exception e) {
            TRACE.catching("createMessageRecord(Party fromParty, Party toParty, Service fromService, Service toService, Action action, String messageId)", e);
            ResourceException re = new ResourceException(e.getMessage());
            TRACE.throwing("createMessageRecord(Party fromParty, Party toParty, Service fromService, Service toService, Action action, String messageId)", re);
            throw re;
        }
        return msg;
    }

    public MappedRecord createMappedRecord(String arg0) throws ResourceException {
        throw new ResourceException("Map records are not supported.");
    }

    public IndexedRecord createIndexedRecord(String arg0) throws ResourceException {
        throw new ResourceException("Index records are not supported");
    }

    public XIMessageRecord createXIMessageRecord() {
        return new XIMessageRecordImpl(null);
    }

    public void ackNotSupported(MessageKey messageKey, AckType[] acksNotSupported) throws MessagingException {
        this.af.ackNotSupported(this.ackfct, messageKey, acksNotSupported);
    }

    public void applicationAck(MessageKey messageToAck) {
        String SIGNATURE = "applicationAck(MessageKey messageToAck)";
        try {
            this.af.applicationAck(this.ackfct, messageToAck);
        }
        catch (Exception e) {
            TRACE.catching("applicationAck(MessageKey messageToAck)", e);
        }
    }

    public void applicationErrorAck(MessageKey messageToAck, Exception error) {
        String SIGNATURE = "applicationErrorAck(MessageKey messageToAck,java.lang.Exception error)";
        try {
            this.af.applicationErrorAck(this.ackfct, messageToAck, error);
        }
        catch (Exception e) {
            TRACE.catching("applicationErrorAck(MessageKey messageToAck,java.lang.Exception error)", e);
        }
    }

    public void deliveryAck(MessageKey messageToAck) {
        String SIGNATURE = "deliveryAck(MessageKey messageToAck)";
        try {
            this.af.deliveryAck(this.ackfct, messageToAck);
        }
        catch (Exception e) {
            TRACE.catching("deliveryAck(MessageKey messageToAck)", e);
        }
    }

    public void deliveryErrorAck(MessageKey messageToAck, Exception error) {
        String SIGNATURE = "deliveryErrorAck(MessageKey messageToAck,java.lang.Exception error)";
        try {
            this.af.deliveryErrorAck(this.ackfct, messageToAck, error);
        }
        catch (Exception e) {
            TRACE.catching("deliveryErrorAck(MessageKey messageToAck,java.lang.Exception error)", e);
        }
    }
}

