/*
 * $Id$
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.slf4j.sap;

import com.sap.tc.logging.Location;

import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class LocationLogger extends MarkerIgnoringBase
{
    private Location location;

    public LocationLogger(Location location)
    {
        super();
        this.location = location;
    }

    public void debug(String msg)
    {
        location.debugT(msg);
    }

    public void debug(String format, Object arg)
    {
        FormattingTuple ft = MessageFormatter.format(format, arg);
        location.debugT(ft.getMessage());
    }

    public void debug(String format, Object[] argArray)
    {
        FormattingTuple ft = MessageFormatter.format(format, argArray);
        location.debugT(ft.getMessage());
    }

    public void debug(String msg, Throwable t)
    {
        FormattingTuple ft = MessageFormatter.format(msg, t);
        location.debugT(ft.getMessage());
    }

    public void debug(String format, Object arg1, Object arg2)
    {
        FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
        location.debugT(ft.getMessage());
    }

    public void error(String msg)
    {
        location.errorT(msg);
    }

    public void error(String format, Object arg)
    {
        FormattingTuple ft = MessageFormatter.format(format, arg);
        location.errorT(ft.getMessage());
    }

    public void error(String format, Object[] argArray)
    {
        FormattingTuple ft = MessageFormatter.format(format, argArray);
        location.errorT(ft.getMessage());
    }

    public void error(String msg, Throwable t)
    {
        FormattingTuple ft = MessageFormatter.format(msg, t);
        location.errorT(ft.getMessage());
    }

    public void error(String format, Object arg1, Object arg2)
    {
        FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
        location.errorT(ft.getMessage());
    }

    public void info(String msg)
    {
        location.infoT(msg);
    }

    public void info(String format, Object arg)
    {
        FormattingTuple ft = MessageFormatter.format(format, arg);
        location.infoT(ft.getMessage());
    }

    public void info(String format, Object[] argArray)
    {
        FormattingTuple ft = MessageFormatter.format(format, argArray);
        location.infoT(ft.getMessage());
    }

    public void info(String msg, Throwable t)
    {
        FormattingTuple ft = MessageFormatter.format(msg, t);
        location.infoT(ft.getMessage());
    }

    public void info(String format, Object arg1, Object arg2)
    {
        FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
        location.infoT(ft.getMessage());
    }

    public boolean isDebugEnabled()
    {
        return location.beDebug();
    }

    public boolean isErrorEnabled()
    {
        return location.beError();
    }

    public boolean isInfoEnabled()
    {
        return location.beInfo();
    }

    public boolean isTraceEnabled()
    {
        return location.beDebug();
    }

    public boolean isWarnEnabled()
    {
        return location.beWarning();
    }

    public void trace(String msg)
    {
        debug(msg);
    }

    public void trace(String format, Object arg)
    {
        debug(format, arg);
    }

    public void trace(String format, Object[] argArray)
    {
        debug(format, argArray);
    }

    public void trace(String msg, Throwable t)
    {
        debug(msg, t);
    }

    public void trace(String format, Object arg1, Object arg2)
    {
        debug(format, arg1, arg2);
    }

    public void warn(String msg)
    {
        location.warningT(msg);
    }

    public void warn(String format, Object arg)
    {
        FormattingTuple ft = MessageFormatter.format(format, arg);
        location.warningT(ft.getMessage());
    }

    public void warn(String format, Object[] argArray)
    {
        FormattingTuple ft = MessageFormatter.format(format, argArray);
        location.warningT(ft.getMessage());
    }

    public void warn(String msg, Throwable t)
    {
        FormattingTuple ft = MessageFormatter.format(msg, t);
        location.warningT(ft.getMessage());
    }

    public void warn(String format, Object arg1, Object arg2)
    {
        FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
        location.warningT(ft.getMessage());
    }
}
