/*
 * $Id$
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.slf4j.sap;

import com.sap.tc.logging.Location;

import java.util.HashMap;

import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class LocationLoggerFactory implements ILoggerFactory
{
    private HashMap<String, LocationLogger> loggers = new HashMap<String, LocationLogger>();

    public Logger getLogger(String name)
    {
        LocationLogger logger = null;
        synchronized (this)
        {
            logger = loggers.get(name);
            if (logger == null)
            {
                logger = createAndRegisterLogger(name);
            }
        }
        return logger;
    }

    private LocationLogger createAndRegisterLogger(String name)
    {
        Location location = Location.getLocation(name);
        LocationLogger logger = new LocationLogger(location);

        loggers.put(name, logger);
        return logger;
    }
}
