/*
 * $Id$
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.slf4j.impl;

import org.mule.slf4j.sap.LocationLoggerFactory;

import org.slf4j.ILoggerFactory;
import org.slf4j.spi.LoggerFactoryBinder;

/**
 * Bridge mule slf4j logs into SPA-PI logging mechanism.
 * This class is the main entry point. It will automatically be loaded by slf4j.
 * @see http://www.slf4j.org/codes.html#StaticLoggerBinder
 */
public class StaticLoggerBinder implements LoggerFactoryBinder
{
    private static final String LOGGER_FACTORY_NAME = LocationLoggerFactory.class.getName();
    private static final StaticLoggerBinder SINGLETON = new StaticLoggerBinder();

    private final LocationLoggerFactory loggerFactory = new LocationLoggerFactory();

    public static StaticLoggerBinder getSingleton()
    {
        return SINGLETON;
    }

    private StaticLoggerBinder()
    {
        System.out.println("Installing slf4j -> com.sap.tc.logging.Location redirection.");
    }

    public final ILoggerFactory getLoggerFactory()
    {
        return loggerFactory;
    }

    public final String getLoggerFactoryClassStr()
    {
        return StaticLoggerBinder.LOGGER_FACTORY_NAME;
    }

}