/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.param.stereotype;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.stereotype.StereotypeDefinition;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation for sources, operations, configurations and Connection Providers l to communicate and declare the
 * {@link StereotypeDefinition}s that characterize the annotated components
 *
 * @since 1.0
 * @see StereotypeDefinition
 */
@Target({TYPE, METHOD})
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.5.0")
public @interface Stereotype {

  Class<? extends StereotypeDefinition> value();
}
