/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.security;

import org.mule.sdk.api.annotation.MinMuleVersion;

/**
 * Describes the possible placements credentials can have inside a HTTP request
 *
 * @since 1.0
 */
@MinMuleVersion("4.5.0")
public enum CredentialsPlacement {

  /**
   * Send credentials in a Basic Authentication header
   */
  @MinMuleVersion("4.5.0")
  BASIC_AUTH_HEADER,

  /**
   * Send credentials encoded in HTTP Body
   */
  @MinMuleVersion("4.5.0")
  BODY,

  /**
   * Send credentials as query parameters
   */
  @MinMuleVersion("4.5.0")
  QUERY_PARAMS
}
