/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.metadata;

import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.api.annotation.Experimental;
import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.metadata.resolving.ChainInputTypeResolver;
import org.mule.sdk.api.runtime.route.Chain;
import org.mule.sdk.api.runtime.route.Route;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Applied to {@link Chain} or {@link Route} parameters, allows specifying a {@link ChainInputTypeResolver} to provide DataSense
 * information about the payload and attributes that will enter said chain/route.
 * <p>
 * <b>NOTE:</b> Experimental feature. Backwards compatibility is not guaranteed.
 *
 * @since 0.9.0
 */
@Target(PARAMETER)
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.7.0")
@DoNotEnforceMinMuleVersion
@Experimental
public @interface ChainInputResolver {

  Class<? extends ChainInputTypeResolver> value();
}
