/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
/**
 * Mule Sdk API for Mule Runtime.
 *
 * @moduleGraph
 * @since 1.0
 */

module org.mule.sdk.api {

  requires transitive org.mule.runtime.api.annotations;
  requires transitive org.mule.runtime.api;
  requires transitive org.mule.runtime.metadata.model.api;
  requires transitive org.mule.runtime.metadata.model.message;
  requires transitive java.transaction.xa;

  exports org.mule.sdk.api.annotation;
  exports org.mule.sdk.api.annotation.binding;
  exports org.mule.sdk.api.annotation.connectivity;
  exports org.mule.sdk.api.annotation.connectivity.oauth;
  exports org.mule.sdk.api.annotation.data.sample;
  exports org.mule.sdk.api.annotation.deprecated;
  exports org.mule.sdk.api.annotation.dsl.xml;
  exports org.mule.sdk.api.annotation.error;
  exports org.mule.sdk.api.annotation.execution;
  exports org.mule.sdk.api.annotation.license;
  exports org.mule.sdk.api.annotation.metadata;
  exports org.mule.sdk.api.annotation.metadata.fixed;
  exports org.mule.sdk.api.annotation.notification;
  exports org.mule.sdk.api.annotation.param;
  exports org.mule.sdk.api.annotation.param.display;
  exports org.mule.sdk.api.annotation.param.reference;
  exports org.mule.sdk.api.annotation.param.stereotype;
  exports org.mule.sdk.api.annotation.route;
  exports org.mule.sdk.api.annotation.semantics;
  exports org.mule.sdk.api.annotation.semantics.connectivity;
  exports org.mule.sdk.api.annotation.semantics.file;
  exports org.mule.sdk.api.annotation.semantics.security;
  exports org.mule.sdk.api.annotation.source;
  exports org.mule.sdk.api.annotation.values;
  exports org.mule.sdk.api.artifact.lifecycle;
  exports org.mule.sdk.api.client;
  exports org.mule.sdk.api.connectivity;
  exports org.mule.sdk.api.connectivity.oauth;
  exports org.mule.sdk.api.data.sample;
  exports org.mule.sdk.api.error;
  exports org.mule.sdk.api.exception;
  exports org.mule.sdk.api.meta;
  exports org.mule.sdk.api.metadata;
  exports org.mule.sdk.api.metadata.resolving;
  exports org.mule.sdk.api.notification;
  exports org.mule.sdk.api.store;
  exports org.mule.sdk.api.runtime.connectivity;
  exports org.mule.sdk.api.runtime.exception;
  exports org.mule.sdk.api.runtime.operation;
  exports org.mule.sdk.api.runtime.parameter;
  exports org.mule.sdk.api.runtime.process;
  exports org.mule.sdk.api.runtime.route;
  exports org.mule.sdk.api.runtime.source;
  exports org.mule.sdk.api.runtime.streaming;
  exports org.mule.sdk.api.security;
  exports org.mule.sdk.api.stereotype;
  exports org.mule.sdk.api.streaming.bytes;
  exports org.mule.sdk.api.tx;
  exports org.mule.sdk.api.values;

  // Introspection by kryo used by mule serializer
  opens org.mule.sdk.api.exception to
      kryo.shaded;

}
