/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.runtime.parameter;

import org.mule.sdk.api.annotation.MinMuleVersion;

/**
 * Describes the possible placements a parameter can have inside a HTTP request
 *
 * @since 1.0
 */
@MinMuleVersion("4.5.0")
public enum HttpParameterPlacement {

  /**
   * The parameter will be sent as a query parameter
   */
  @MinMuleVersion("4.5.0")
  QUERY_PARAMS,

  /**
   * The parameter will be sent as a header
   */
  @MinMuleVersion("4.5.0")
  HEADERS,

  /**
   * The parameter will be added as part of an {@code application/x-www-form-urlencoded} Http request body
   */
  @MinMuleVersion("4.5.0")
  BODY
}
