/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.domain.message.response;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.http.HttpService;
import org.mule.sdk.api.http.domain.message.HttpMessageBuilder;

/**
 * Builder of {@link HttpResponse}s. Instances can only be obtained using {@link HttpService#responseBuilder()} or
 * {@link HttpService#responseBuilder(HttpResponse)}. By default, the status code is 200 with empty reason phrase, headers, and
 * entity.
 *
 * @since 0.12.0
 */
@Experimental
@NoImplement
@MinMuleVersion("4.10.0")
public interface HttpResponseBuilder extends HttpMessageBuilder<HttpResponseBuilder, HttpResponse> {

  /**
   * @param statusCode the HTTP status line code desired for the {@link HttpResponse}
   * @return this builder
   */
  HttpResponseBuilder statusCode(Integer statusCode);

  /**
   * @param reasonPhrase the HTTP status line reason phrase desired for the {@link HttpResponse}
   * @return this builder
   */
  HttpResponseBuilder reasonPhrase(String reasonPhrase);

  /**
   * @return the current status code configured in the builder.
   */
  int getStatusCode();

  /**
   * @return the current reason phrase configured in the builder.
   */
  String getReasonPhrase();
}
