/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.route;

import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.runtime.route.Chain;
import org.mule.sdk.api.runtime.route.Route;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Used in method arguments of type {@link Chain} or {@link Route}, specifies how many times the chain in a scope or route is
 * expected to be called each time the owning component is executed.
 * <p>
 * Usage of this annotation does not increase the components min mule version.
 *
 * @since 0.9
 */
@Target(PARAMETER)
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.7")
@DoNotEnforceMinMuleVersion
public @interface ExecutionOccurrence {

  ChainExecutionOccurrence value();
}
