/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.client.auth;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.sdk.api.annotation.MinMuleVersion;

/**
 * Allows configuring the authentication parameters.
 *
 * @since 0.12.0
 */
@Experimental
@NoImplement
@MinMuleVersion("4.10.0")
public interface HttpAuthenticationConfigurer {

  /**
   * Configures basic authentication.
   *
   * @param username   User name.
   * @param password   Password.
   * @param preemptive whether it should send the authentication header in the first request, without waiting for a 401.
   */
  void basic(String username, String password, boolean preemptive);

  /**
   * Configures digest authentication.
   *
   * @param username   User name.
   * @param password   Password.
   * @param preemptive whether it should send the authentication header in the first request, without waiting for a 401.
   */
  void digest(String username, String password, boolean preemptive);

  /**
   * Configures NTLM authentication.
   *
   * @param username    User name.
   * @param password    Password.
   * @param preemptive  whether it should send the authentication header in the first request, without waiting for a 401.
   * @param domain      NTLM Domain.
   * @param workstation NTLM workstation.
   */
  void ntlm(String username, String password, boolean preemptive, String domain, String workstation);
}
