/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.tcp;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.sdk.api.annotation.MinMuleVersion;

/**
 * Allows configuring the TCP properties
 *
 * @since 0.12.0
 */
@Experimental
@NoImplement
@MinMuleVersion("4.10.0")
public interface TcpSocketPropertiesConfigurer {

  /**
   * Defines the size of the buffer to use when sending data.
   *
   * @param sendBufferSize size of the buffer (in bytes).
   * @return this configurer
   */
  TcpSocketPropertiesConfigurer sendBufferSize(Integer sendBufferSize);

  /**
   * Defines the size of the buffer to use when receiving data.
   *
   * @param receiveBufferSize size of the buffer (in bytes).
   * @return this configurer
   */
  TcpSocketPropertiesConfigurer receiveBufferSize(Integer receiveBufferSize);

  /**
   * Defines the SO_TIMEOUT value for client sockets.
   *
   * @param clientTimeout the timeout (in milliseconds).
   * @return this configurer
   */
  TcpSocketPropertiesConfigurer clientTimeout(Integer clientTimeout);

  /**
   * Defines whether data should be collected or not before sending.
   *
   * @param sendTcpNoDelay whether to send everything or collect data
   * @return this configurer
   */
  TcpSocketPropertiesConfigurer sendTcpNoDelay(Boolean sendTcpNoDelay);

  /**
   * Defines the SO_LINGER value, related to how long the socket will take to close.
   *
   * @param linger timeout (in milliseconds)
   * @return this configurer
   */
  TcpSocketPropertiesConfigurer linger(Integer linger);

  /**
   * Defines the SO_KEEPALIVE behavior for open sockets.
   *
   * @param keepAlive the value
   * @return this configurer
   */
  TcpSocketPropertiesConfigurer keepAlive(Boolean keepAlive);

  /**
   * Defines how long to wait for the outbound connection to be created.
   *
   * @param connectionTimeout timeout (in milliseconds)
   * @return this configurer
   */
  TcpSocketPropertiesConfigurer connectionTimeout(Integer connectionTimeout);
}
