/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.domain.message.request;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.util.MultiMap;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.http.domain.HttpProtocolVersion;
import org.mule.sdk.api.http.domain.message.HttpMessage;

import java.net.URI;

/**
 * Representation of an HTTP request message.
 *
 * @since 0.12.0
 */
@Experimental
@NoImplement
@MinMuleVersion("4.10.0")
public interface HttpRequest extends HttpMessage {

  /**
   * @return the protocol version
   */
  HttpProtocolVersion getProtocolVersion();

  /**
   * @return the request path extracted from the URI
   */
  String getPath();

  /**
   * @return the request HTTP method
   */
  String getMethod();

  /**
   * @return the request URI
   */
  URI getUri();

  /**
   * @return the query parameters
   */
  MultiMap<String, String> getQueryParams();

}
